/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.updater;

import java.io.IOException;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexStoreView;

public class UpdateCountingIndexUpdater
implements IndexUpdater {
    private final IndexStoreView storeView;
    private final long indexId;
    private final IndexUpdater delegate;
    private long updates;

    public UpdateCountingIndexUpdater(IndexStoreView storeView, long indexId, IndexUpdater delegate) {
        this.storeView = storeView;
        this.indexId = indexId;
        this.delegate = delegate;
    }

    @Override
    public void process(IndexEntryUpdate update) throws IOException, IndexEntryConflictException {
        this.delegate.process(update);
        ++this.updates;
    }

    @Override
    public void close() throws IOException, IndexEntryConflictException {
        this.delegate.close();
        this.storeView.incrementIndexUpdates(this.indexId, this.updates);
    }

    @Override
    public void remove(PrimitiveLongSet nodeIds) throws IOException {
        this.delegate.remove(nodeIds);
        this.updates += (long)nodeIds.size();
    }
}

