/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.Optional;
import org.neo4j.graphdb.TransactionGuardException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.guard.GuardException;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.procedure.TerminationGuard;

public class TerminationGuardProvider
implements ComponentRegistry.Provider<TerminationGuard> {
    private final Guard guard;

    public TerminationGuardProvider(Guard guard) {
        this.guard = guard;
    }

    public TerminationGuard apply(Context ctx) throws ProcedureException {
        KernelTransaction ktx = ctx.get(Context.KERNEL_TRANSACTION);
        return new TransactionTerminationGuard(ktx);
    }

    private class TransactionTerminationGuard
    implements TerminationGuard {
        private final KernelTransaction ktx;

        TransactionTerminationGuard(KernelTransaction ktx) {
            this.ktx = ktx;
        }

        @Override
        public void check() {
            Optional<Status> terminationReason = this.ktx.getReasonIfTerminated();
            if (terminationReason.isPresent()) {
                throw new TransactionTerminatedException(terminationReason.get());
            }
            if (this.ktx.isOpen()) {
                try {
                    TerminationGuardProvider.this.guard.check((KernelTransactionImplementation)this.ktx);
                }
                catch (GuardException e) {
                    throw new TransactionGuardException(e.status(), "Transaction guard check failed", (Throwable)e);
                }
            }
        }
    }
}

