/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.exceptions.index.FlipFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexCountsRemover;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;

public class MultipleIndexPopulator
implements IndexPopulator {
    public static final String QUEUE_THRESHOLD_NAME = "queue_threshold";
    private final int QUEUE_THRESHOLD = FeatureToggles.getInteger(this.getClass(), (String)"queue_threshold", (int)20000);
    protected final Queue<IndexEntryUpdate> queue = new LinkedBlockingQueue<IndexEntryUpdate>();
    private final List<IndexPopulation> populations = new CopyOnWriteArrayList<IndexPopulation>();
    private final IndexStoreView storeView;
    private final LogProvider logProvider;
    protected final Log log;
    private StoreScan<IndexPopulationFailedKernelException> storeScan;

    public MultipleIndexPopulator(IndexStoreView storeView, LogProvider logProvider) {
        this.storeView = storeView;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(IndexPopulationJob.class);
    }

    public IndexPopulation addPopulator(IndexPopulator populator, long indexId, IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory, String indexUserDescription) {
        IndexPopulation population = this.createPopulation(populator, indexId, descriptor, providerDescriptor, flipper, failedIndexProxyFactory, indexUserDescription);
        this.populations.add(population);
        return population;
    }

    protected IndexPopulation createPopulation(IndexPopulator populator, long indexId, IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory, String indexUserDescription) {
        return new IndexPopulation(populator, indexId, descriptor, providerDescriptor, flipper, failedIndexProxyFactory, indexUserDescription);
    }

    public boolean hasPopulators() {
        return !this.populations.isEmpty();
    }

    @Override
    public void create() {
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)population -> {
            this.log.info("Index population started: [%s]", new Object[]{population.indexUserDescription});
            population.populator.create();
        }));
    }

    @Override
    public void drop() throws IOException {
        throw new UnsupportedOperationException("Can't drop indexes from this populator implementation");
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) {
        throw new UnsupportedOperationException("Can't populate directly using this populator implementation. ");
    }

    @Override
    public void add(IndexEntryUpdate<?> update) {
        throw new UnsupportedOperationException("Can't populate directly using this populator implementation. ");
    }

    public StoreScan<IndexPopulationFailedKernelException> indexAllNodes() {
        int[] labelIds = this.labelIds();
        int[] propertyKeyIds = this.propertyKeyIds();
        IntPredicate propertyKeyIdFilter = propertyKeyId -> PrimitiveIntCollections.contains((int[])propertyKeyIds, (int)propertyKeyId);
        this.storeScan = this.storeView.visitNodes(labelIds, propertyKeyIdFilter, new NodePopulationVisitor(), null, false);
        this.storeScan.configure(this.populations);
        return this.storeScan;
    }

    public void queue(IndexEntryUpdate update) {
        this.queue.add(update);
    }

    public void fail(Throwable failure) {
        for (IndexPopulation population : this.populations) {
            this.fail(population, failure);
        }
    }

    protected void fail(IndexPopulation population, Throwable failure) {
        Throwable cause;
        if (!this.populations.remove(population)) {
            return;
        }
        if (failure instanceof IndexPopulationFailedKernelException && (cause = failure.getCause()) instanceof IndexEntryConflictException) {
            failure = cause;
        }
        if (!(failure instanceof IndexEntryConflictException)) {
            this.log.error(String.format("Failed to populate index: [%s]", population.indexUserDescription), failure);
        }
        population.flipToFailed(failure);
        try {
            population.populator.markAsFailed(IndexPopulationFailure.failure(failure).asString());
            population.populator.close(false);
        }
        catch (Throwable e) {
            this.log.error(String.format("Unable to close failed populator for index: [%s]", population.indexUserDescription), e);
        }
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
        throw new UnsupportedOperationException("Should not be called directly");
    }

    @Override
    public MultipleIndexUpdater newPopulatingUpdater(PropertyAccessor accessor) {
        HashMap<LabelSchemaDescriptor, Pair<IndexPopulation, IndexUpdater>> updaters = new HashMap<LabelSchemaDescriptor, Pair<IndexPopulation, IndexUpdater>>();
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)population -> {
            IndexUpdater updater = population.populator.newPopulatingUpdater(accessor);
            updaters.put(population.descriptor.schema(), Pair.of((Object)population, (Object)updater));
        }));
        return new MultipleIndexUpdater(this, updaters, this.logProvider);
    }

    @Override
    public void close(boolean populationCompletedSuccessfully) {
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)population -> population.populator.close(populationCompletedSuccessfully)));
    }

    @Override
    public void markAsFailed(String failure) throws IOException {
        throw new UnsupportedOperationException("Multiple index populator can't be marked as failed.");
    }

    @Override
    public void includeSample(IndexEntryUpdate update) {
        throw new UnsupportedOperationException("Multiple index populator can't perform index sampling.");
    }

    @Override
    public void configureSampling(boolean onlineSampling) {
        throw new UnsupportedOperationException("Multiple index populator can't be configured.");
    }

    @Override
    public IndexSample sampleResult() {
        throw new UnsupportedOperationException("Multiple index populator can't perform index sampling.");
    }

    public void replaceIndexCounts(long uniqueElements, long maxUniqueElements, long indexSize) {
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)population -> this.storeView.replaceIndexCounts(population.indexId, uniqueElements, maxUniqueElements, indexSize)));
    }

    public void flipAfterPopulation() {
        for (IndexPopulation population : this.populations) {
            try {
                population.flip();
                this.populations.remove(population);
            }
            catch (Throwable t) {
                this.fail(population, t);
            }
        }
    }

    private int[] propertyKeyIds() {
        return this.populations.stream().flatMapToInt(this::propertyKeyIds).distinct().toArray();
    }

    private IntStream propertyKeyIds(IndexPopulation population) {
        return IntStream.of(population.schema().getPropertyIds());
    }

    private int[] labelIds() {
        return this.populations.stream().mapToInt(population -> population.schema().getLabelId()).toArray();
    }

    public void cancel() {
        this.replaceIndexCounts(0L, 0L, 0L);
        this.close(false);
    }

    void populateFromQueueBatched(long currentlyIndexedNodeId) {
        if (this.isQueueThresholdReached()) {
            this.populateFromQueue(currentlyIndexedNodeId);
        }
    }

    private boolean isQueueThresholdReached() {
        return this.queue.size() >= this.QUEUE_THRESHOLD;
    }

    protected void populateFromQueue(long currentlyIndexedNodeId) {
        this.populateFromQueueIfAvailable(currentlyIndexedNodeId);
    }

    private void populateFromQueueIfAvailable(long currentlyIndexedNodeId) {
        if (!this.queue.isEmpty()) {
            try (MultipleIndexUpdater updater = this.newPopulatingUpdater(this.storeView);){
                do {
                    IndexEntryUpdate update = this.queue.poll();
                    this.storeScan.acceptUpdate(updater, update, currentlyIndexedNodeId);
                } while (!this.queue.isEmpty());
            }
        }
    }

    private void forEachPopulation(ThrowingConsumer<IndexPopulation, Exception> action) {
        for (IndexPopulation population : this.populations) {
            try {
                action.accept((Object)population);
            }
            catch (Throwable failure) {
                this.fail(population, failure);
            }
        }
    }

    private class NodePopulationVisitor
    implements Visitor<NodeUpdates, IndexPopulationFailedKernelException> {
        private NodePopulationVisitor() {
        }

        public boolean visit(NodeUpdates updates) throws IndexPopulationFailedKernelException {
            this.add(updates);
            MultipleIndexPopulator.this.populateFromQueueBatched(updates.getNodeId());
            return false;
        }

        private void add(NodeUpdates updates) {
            for (IndexEntryUpdate indexUpdate : updates.forIndexKeys(MultipleIndexPopulator.this.populations)) {
                try {
                    ((IndexPopulation)indexUpdate.indexKey()).onUpdate(indexUpdate);
                }
                catch (Throwable failure) {
                    MultipleIndexPopulator.this.fail((IndexPopulation)indexUpdate.indexKey(), failure);
                }
            }
        }
    }

    public class IndexPopulation
    implements LabelSchemaSupplier {
        public final IndexPopulator populator;
        final long indexId;
        final IndexDescriptor descriptor;
        final SchemaIndexProvider.Descriptor providerDescriptor;
        final IndexCountsRemover indexCountsRemover;
        final FlippableIndexProxy flipper;
        final FailedIndexProxyFactory failedIndexProxyFactory;
        final String indexUserDescription;

        IndexPopulation(IndexPopulator populator, long indexId, IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory, String indexUserDescription) {
            this.populator = populator;
            this.indexId = indexId;
            this.descriptor = descriptor;
            this.providerDescriptor = providerDescriptor;
            this.flipper = flipper;
            this.failedIndexProxyFactory = failedIndexProxyFactory;
            this.indexUserDescription = indexUserDescription;
            this.indexCountsRemover = new IndexCountsRemover(MultipleIndexPopulator.this.storeView, indexId);
        }

        private void flipToFailed(Throwable t) {
            this.flipper.flipTo(new FailedIndexProxy(this.descriptor, this.providerDescriptor, this.indexUserDescription, this.populator, IndexPopulationFailure.failure(t), this.indexCountsRemover, MultipleIndexPopulator.this.logProvider));
        }

        private void onUpdate(IndexEntryUpdate update) throws IndexEntryConflictException, IOException {
            this.populator.includeSample(update);
            this.add(update);
        }

        void add(IndexEntryUpdate update) throws IOException, IndexEntryConflictException {
            this.populator.add(update);
        }

        private void flip() throws FlipFailedKernelException {
            this.flipper.flip(() -> {
                MultipleIndexPopulator.this.populateFromQueueIfAvailable(Long.MAX_VALUE);
                IndexSample sample = this.populator.sampleResult();
                MultipleIndexPopulator.this.storeView.replaceIndexCounts(this.indexId, sample.uniqueValues(), sample.sampleSize(), sample.indexSize());
                this.populator.close(true);
                return null;
            }, this.failedIndexProxyFactory);
            MultipleIndexPopulator.this.log.info("Index population completed. Index is now online: [%s]", new Object[]{this.indexUserDescription});
        }

        @Override
        public LabelSchemaDescriptor schema() {
            return this.descriptor.schema();
        }
    }

    public static class MultipleIndexUpdater
    implements IndexUpdater {
        private final Map<LabelSchemaDescriptor, Pair<IndexPopulation, IndexUpdater>> populationsWithUpdaters;
        private final MultipleIndexPopulator multipleIndexPopulator;
        private final Log log;

        MultipleIndexUpdater(MultipleIndexPopulator multipleIndexPopulator, Map<LabelSchemaDescriptor, Pair<IndexPopulation, IndexUpdater>> populationsWithUpdaters, LogProvider logProvider) {
            this.multipleIndexPopulator = multipleIndexPopulator;
            this.populationsWithUpdaters = populationsWithUpdaters;
            this.log = logProvider.getLog(this.getClass());
        }

        @Override
        public void remove(PrimitiveLongSet nodeIds) {
            throw new UnsupportedOperationException("Index populators don't do removal");
        }

        @Override
        public void process(IndexEntryUpdate update) {
            Pair<IndexPopulation, IndexUpdater> pair = this.populationsWithUpdaters.get(update.indexKey().schema());
            if (pair != null) {
                IndexPopulation population = (IndexPopulation)pair.first();
                IndexUpdater updater = (IndexUpdater)pair.other();
                try {
                    updater.process(update);
                }
                catch (Throwable t) {
                    try {
                        updater.close();
                    }
                    catch (Throwable ce) {
                        this.log.error(String.format("Failed to close index updater: [%s]", updater), ce);
                    }
                    this.populationsWithUpdaters.remove(update.indexKey().schema());
                    this.multipleIndexPopulator.fail(population, t);
                }
            }
        }

        @Override
        public void close() {
            for (Pair<IndexPopulation, IndexUpdater> pair : this.populationsWithUpdaters.values()) {
                IndexPopulation population = (IndexPopulation)pair.first();
                IndexUpdater updater = (IndexUpdater)pair.other();
                try {
                    updater.close();
                }
                catch (Throwable t) {
                    this.multipleIndexPopulator.fail(population, t);
                }
            }
            this.populationsWithUpdaters.clear();
        }
    }
}

