/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntCollection;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.impl.api.index.IndexProxy;

public final class IndexMap
implements Cloneable {
    private final Map<Long, IndexProxy> indexesById;
    private final Map<LabelSchemaDescriptor, IndexProxy> indexesByDescriptor;
    private final Map<LabelSchemaDescriptor, Long> indexIdsByDescriptor;
    private final PrimitiveIntObjectMap<Set<LabelSchemaDescriptor>> descriptorsByLabel;
    private final PrimitiveIntObjectMap<Set<LabelSchemaDescriptor>> descriptorsByProperty;

    public IndexMap() {
        this(new HashMap<Long, IndexProxy>(), new HashMap<LabelSchemaDescriptor, IndexProxy>(), new HashMap<LabelSchemaDescriptor, Long>());
    }

    IndexMap(Map<Long, IndexProxy> indexesById) {
        this(indexesById, IndexMap.indexesByDescriptor(indexesById), IndexMap.indexIdsByDescriptor(indexesById));
    }

    private IndexMap(Map<Long, IndexProxy> indexesById, Map<LabelSchemaDescriptor, IndexProxy> indexesByDescriptor, Map<LabelSchemaDescriptor, Long> indexIdsByDescriptor) {
        this.indexesById = indexesById;
        this.indexesByDescriptor = indexesByDescriptor;
        this.indexIdsByDescriptor = indexIdsByDescriptor;
        this.descriptorsByLabel = Primitive.intObjectMap();
        this.descriptorsByProperty = Primitive.intObjectMap();
        for (LabelSchemaDescriptor schema : indexesByDescriptor.keySet()) {
            this.addDescriptorToLookups(schema);
        }
    }

    public IndexProxy getIndexProxy(long indexId) {
        return this.indexesById.get(indexId);
    }

    public IndexProxy getIndexProxy(LabelSchemaDescriptor descriptor) {
        return this.indexesByDescriptor.get(descriptor);
    }

    public long getIndexId(LabelSchemaDescriptor descriptor) {
        return this.indexIdsByDescriptor.get(descriptor);
    }

    public void putIndexProxy(long indexId, IndexProxy indexProxy) {
        LabelSchemaDescriptor schema = indexProxy.getDescriptor().schema();
        this.indexesById.put(indexId, indexProxy);
        this.indexesByDescriptor.put(schema, indexProxy);
        this.indexIdsByDescriptor.put(schema, indexId);
        this.addDescriptorToLookups(schema);
    }

    public IndexProxy removeIndexProxy(long indexId) {
        IndexProxy removedProxy = this.indexesById.remove(indexId);
        if (removedProxy == null) {
            return null;
        }
        LabelSchemaDescriptor schema = removedProxy.getDescriptor().schema();
        this.indexesByDescriptor.remove(schema);
        this.removeFromLookup(schema.getLabelId(), schema, this.descriptorsByLabel);
        for (int propertyId : schema.getPropertyIds()) {
            this.removeFromLookup(propertyId, schema, this.descriptorsByProperty);
        }
        return removedProxy;
    }

    public void foreachIndexProxy(BiConsumer<Long, IndexProxy> consumer) {
        for (Map.Entry<Long, IndexProxy> entry : this.indexesById.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }

    public Iterable<IndexProxy> getAllIndexProxies() {
        return this.indexesById.values();
    }

    public Set<LabelSchemaDescriptor> getRelatedIndexes(long[] changedLabels, long[] unchangedLabels, PrimitiveIntCollection properties) {
        if (changedLabels.length == 1 && properties.isEmpty()) {
            Set descriptors = (Set)this.descriptorsByLabel.get((int)changedLabels[0]);
            return descriptors == null ? Collections.emptySet() : descriptors;
        }
        if (changedLabels.length == 0 && properties.size() == 1) {
            return this.getDescriptorsByProperties(unchangedLabels, properties);
        }
        Set<LabelSchemaDescriptor> descriptors = this.extractIndexesByLabels(changedLabels);
        descriptors.addAll(this.getDescriptorsByProperties(unchangedLabels, properties));
        return descriptors;
    }

    public IndexMap clone() {
        return new IndexMap(this.cloneMap(this.indexesById), this.cloneMap(this.indexesByDescriptor), this.cloneMap(this.indexIdsByDescriptor));
    }

    public Iterator<LabelSchemaDescriptor> descriptors() {
        return this.indexesByDescriptor.keySet().iterator();
    }

    public Iterator<Long> indexIds() {
        return this.indexesById.keySet().iterator();
    }

    public int size() {
        return this.indexesById.size();
    }

    private <K, V> Map<K, V> cloneMap(Map<K, V> map) {
        HashMap<K, V> shallowCopy = new HashMap<K, V>(map.size());
        shallowCopy.putAll(map);
        return shallowCopy;
    }

    private void addDescriptorToLookups(LabelSchemaDescriptor schema) {
        this.addToLookup(schema.getLabelId(), schema, this.descriptorsByLabel);
        for (int propertyId : schema.getPropertyIds()) {
            this.addToLookup(propertyId, schema, this.descriptorsByProperty);
        }
    }

    private void addToLookup(int key, LabelSchemaDescriptor schema, PrimitiveIntObjectMap<Set<LabelSchemaDescriptor>> lookup) {
        HashSet<LabelSchemaDescriptor> descriptors = (HashSet<LabelSchemaDescriptor>)lookup.get(key);
        if (descriptors == null) {
            descriptors = new HashSet<LabelSchemaDescriptor>();
            lookup.put(key, descriptors);
        }
        descriptors.add(schema);
    }

    private void removeFromLookup(int key, LabelSchemaDescriptor schema, PrimitiveIntObjectMap<Set<LabelSchemaDescriptor>> lookup) {
        Set descriptors = (Set)lookup.get(key);
        descriptors.remove(schema);
        if (descriptors.isEmpty()) {
            lookup.remove(key);
        }
    }

    private static Map<LabelSchemaDescriptor, IndexProxy> indexesByDescriptor(Map<Long, IndexProxy> indexesById) {
        HashMap<LabelSchemaDescriptor, IndexProxy> map = new HashMap<LabelSchemaDescriptor, IndexProxy>();
        for (IndexProxy proxy : indexesById.values()) {
            map.put(proxy.schema(), proxy);
        }
        return map;
    }

    private static Map<LabelSchemaDescriptor, Long> indexIdsByDescriptor(Map<Long, IndexProxy> indexesById) {
        HashMap<LabelSchemaDescriptor, Long> map = new HashMap<LabelSchemaDescriptor, Long>();
        for (Map.Entry<Long, IndexProxy> entry : indexesById.entrySet()) {
            map.put(entry.getValue().schema(), entry.getKey());
        }
        return map;
    }

    private Set<LabelSchemaDescriptor> getDescriptorsByProperties(long[] unchangedLabels, PrimitiveIntCollection properties) {
        int nIndexesForLabels = this.countIndexesByLabels(unchangedLabels);
        int nIndexesForProperties = this.countIndexesByProperties(properties);
        if (nIndexesForLabels == 0 || nIndexesForProperties == 0) {
            return Collections.emptySet();
        }
        if (nIndexesForLabels < nIndexesForProperties) {
            return this.extractIndexesByLabels(unchangedLabels);
        }
        return this.extractIndexesByProperties(properties);
    }

    private Set<LabelSchemaDescriptor> extractIndexesByLabels(long[] labels) {
        HashSet<LabelSchemaDescriptor> set = new HashSet<LabelSchemaDescriptor>();
        for (long label : labels) {
            Set forLabel = (Set)this.descriptorsByLabel.get((int)label);
            if (forLabel == null) continue;
            set.addAll(forLabel);
        }
        return set;
    }

    private int countIndexesByLabels(long[] labels) {
        int count = 0;
        for (long label : labels) {
            Set forLabel = (Set)this.descriptorsByLabel.get((int)label);
            if (forLabel == null) continue;
            count += forLabel.size();
        }
        return count;
    }

    private Set<LabelSchemaDescriptor> extractIndexesByProperties(PrimitiveIntCollection properties) {
        HashSet<LabelSchemaDescriptor> set = new HashSet<LabelSchemaDescriptor>();
        PrimitiveIntIterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            Set forProperty = (Set)this.descriptorsByProperty.get(iterator.next());
            if (forProperty == null) continue;
            set.addAll(forProperty);
        }
        return set;
    }

    private int countIndexesByProperties(PrimitiveIntCollection properties) {
        int count = 0;
        PrimitiveIntIterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            Set forProperty = (Set)this.descriptorsByProperty.get(iterator.next());
            if (forProperty == null) continue;
            count += forProperty.size();
        }
        return count;
    }
}

