/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.schema_new.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptorFactory;

public class RelationshipPropertyExistenceException
extends ConstraintValidationException {
    private final RelationTypeSchemaDescriptor schema;
    private final long relationshipId;

    public RelationshipPropertyExistenceException(RelationTypeSchemaDescriptor schema, ConstraintValidationException.Phase phase, long relationshipId) {
        super(ConstraintDescriptorFactory.existsForSchema(schema), phase, String.format("Relationship(%s)", relationshipId));
        this.schema = schema;
        this.relationshipId = relationshipId;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format("Relationship(%s) with type `%s` must have the property `%s`", this.relationshipId, tokenNameLookup.relationshipTypeGetName(this.schema.getRelTypeId()), tokenNameLookup.propertyKeyGetName(this.schema.getPropertyId()));
    }
}

