/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.QuantizedProjection;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.DetailLevel;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.stats.StepStats;

public class SpectrumExecutionMonitor
extends ExecutionMonitor.Adapter {
    public static final int DEFAULT_WIDTH = 100;
    private static final int PROGRESS_WIDTH = 5;
    private static final char[] WEIGHTS = new char[]{' ', 'K', 'M', 'B', 'T'};
    private final PrintStream out;
    private final int width;
    private long tick;
    private long lastProgress;

    public SpectrumExecutionMonitor(long interval, TimeUnit unit, PrintStream out, int width) {
        super(interval, unit);
        this.out = out;
        this.width = width;
    }

    @Override
    public void start(StageExecution[] executions) {
        for (int i = 0; i < executions.length; ++i) {
            if (i > 0) {
                this.out.print(", ");
            }
            this.out.print(executions[i].getStageName());
        }
        this.out.println();
        this.tick = 0L;
        this.lastProgress = 0L;
    }

    @Override
    public void end(StageExecution[] executions, long totalTimeMillis) {
        this.check(executions);
        this.out.println();
        this.out.println("Done in " + Format.duration(totalTimeMillis));
    }

    @Override
    public void done(long totalTimeMillis, String additionalInformation) {
        this.out.println();
        this.out.println("IMPORT DONE in " + Format.duration(totalTimeMillis) + ". " + additionalInformation);
    }

    @Override
    public void check(StageExecution[] executions) {
        StageExecution execution = this.rotatedExecution(executions);
        if (execution != null) {
            StringBuilder builder = new StringBuilder();
            this.printSpectrum(builder, execution, this.width);
            this.out.print("\r" + builder);
        }
    }

    private StageExecution rotatedExecution(StageExecution[] executions) {
        ArrayList<StageExecution> active = new ArrayList<StageExecution>(executions.length);
        for (StageExecution execution : executions) {
            if (!execution.stillExecuting()) continue;
            active.add(execution);
        }
        return !active.isEmpty() ? (StageExecution)active.get((int)(this.tick++ % (long)active.size())) : null;
    }

    private void printSpectrum(StringBuilder builder, StageExecution execution, int width) {
        long[] values = this.values(execution);
        long total = this.total(values);
        Pair<Step<?>, Float> bottleNeck = execution.stepsOrderedBy(Keys.avg_processing_time, false).iterator().next();
        QuantizedProjection projection = new QuantizedProjection(total, width -= 7);
        long lastDoneBatches = 0L;
        int stepIndex = 0;
        boolean hasProgressed = false;
        builder.append('[');
        for (Step<?> step : execution.steps()) {
            long stepWidth;
            StepStats stats = step.stats();
            if (!projection.next(values[stepIndex])) break;
            long l = stepWidth = total == 0L && stepIndex == 0 ? (long)width : projection.step();
            if (stepWidth > 0L) {
                if (hasProgressed) {
                    --stepWidth;
                    builder.append('|');
                }
                boolean isBottleNeck = bottleNeck.first() == step;
                String name = (isBottleNeck ? "*" : "") + stats.toString(DetailLevel.IMPORTANT) + (step.processors(0) > 1 ? "(" + step.processors(0) + ")" : "");
                int charIndex = 0;
                char backgroundChar = step.processors(0) > 1 ? (char)'=' : '-';
                int i = 0;
                while ((long)i < stepWidth) {
                    char ch = backgroundChar;
                    if (charIndex >= 0 && charIndex < name.length() && (long)charIndex < stepWidth) {
                        ch = name.charAt(charIndex);
                    }
                    builder.append(ch);
                    ++i;
                    ++charIndex;
                }
                hasProgressed = true;
            }
            lastDoneBatches = stats.stat(Keys.done_batches).asLong();
            ++stepIndex;
        }
        long progress = lastDoneBatches * (long)execution.getConfig().batchSize();
        builder.append("]").append(SpectrumExecutionMonitor.fitInProgress(progress));
        long currentDelta = progress - this.lastProgress;
        builder.append(" \u2206" + SpectrumExecutionMonitor.fitInProgress(currentDelta));
        this.lastProgress = progress;
    }

    private static String fitInProgress(long value) {
        String progress;
        int weight = SpectrumExecutionMonitor.weight(value);
        if (weight == 0) {
            progress = String.valueOf(value);
        } else {
            double floatValue = (double)value / Math.pow(1000.0, weight);
            progress = String.valueOf(floatValue);
            if (progress.length() > 4) {
                progress = progress.substring(0, 4);
            }
            if (progress.endsWith(".")) {
                progress = progress.substring(0, progress.length() - 1);
            }
            progress = progress + WEIGHTS[weight];
        }
        return SpectrumExecutionMonitor.pad(progress, 5, ' ');
    }

    private static String pad(String result, int length, char padChar) {
        while (result.length() < length) {
            result = padChar + result;
        }
        return result;
    }

    private static int weight(long value) {
        int weight = 0;
        while (value >= 1000L) {
            value /= 1000L;
            ++weight;
        }
        return weight;
    }

    private long[] values(StageExecution execution) {
        long[] values = new long[execution.size()];
        int i = 0;
        for (Step<?> step : execution.steps()) {
            values[i++] = this.avg(step.stats());
        }
        return values;
    }

    private long total(long[] values) {
        long total = 0L;
        for (long value : values) {
            total += value;
        }
        return total;
    }

    private long avg(StatsProvider step) {
        return step.stat(Keys.avg_processing_time).asLong();
    }
}

