/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;

public interface Configuration
extends org.neo4j.unsafe.impl.batchimport.staging.Configuration {
    public static final String BAD_FILE_NAME = "bad.log";
    public static final long MAX_PAGE_CACHE_MEMORY = ByteUnit.mebiBytes((long)240L);
    public static final Configuration DEFAULT = new Default();

    public int denseNodeThreshold();

    public long pageCacheMemory();

    public static Configuration withBatchSize(Configuration config, final int batchSize) {
        return new Overridden(config){

            @Override
            public int batchSize() {
                return batchSize;
            }
        };
    }

    public static class Overridden
    extends Configuration.Overridden
    implements Configuration {
        private final Configuration defaults;
        private final Config config;

        public Overridden(Configuration defaults) {
            this(defaults, Config.embeddedDefaults(new ConfigurationValidator[0]));
        }

        public Overridden(Configuration defaults, Config config) {
            super(defaults);
            this.defaults = defaults;
            this.config = config;
        }

        public Overridden(Config config) {
            this(DEFAULT, config);
        }

        @Override
        public long pageCacheMemory() {
            Long pageCacheMemory = this.config.get(GraphDatabaseSettings.pagecache_memory);
            if (pageCacheMemory == null) {
                pageCacheMemory = ConfiguringPageCacheFactory.defaultHeuristicPageCacheMemory();
            }
            return Math.min(MAX_PAGE_CACHE_MEMORY, pageCacheMemory);
        }

        @Override
        public int denseNodeThreshold() {
            return this.config.get(GraphDatabaseSettings.dense_node_threshold);
        }

        @Override
        public int movingAverageSize() {
            return this.defaults.movingAverageSize();
        }
    }

    public static class Default
    extends Configuration.Default
    implements Configuration {
        @Override
        public long pageCacheMemory() {
            long defaultPageCacheMemory = ConfiguringPageCacheFactory.defaultHeuristicPageCacheMemory();
            return Math.min(MAX_PAGE_CACHE_MEMORY, defaultPageCacheMemory);
        }

        @Override
        public int denseNodeThreshold() {
            return Integer.parseInt(GraphDatabaseSettings.dense_node_threshold.getDefaultValue());
        }
    }
}

