/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema_new.SchemaDescriptorPredicates;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.SchemaRule;

class IndexLookup
implements AutoCloseable {
    private final List<IndexAccessor> indexAccessors;
    private final Map<IndexRule, IndexReader> readerCache;
    private final SchemaIndexProvider schemaIndexProvider;
    private final PrimitiveIntObjectMap<List<IndexRule>> indexRuleIndex;
    private final IndexSamplingConfig samplingConfig;

    public IndexLookup(SchemaStore store, SchemaIndexProvider schemaIndexProvider) {
        this.schemaIndexProvider = schemaIndexProvider;
        this.indexAccessors = new ArrayList<IndexAccessor>();
        this.readerCache = new HashMap<IndexRule, IndexReader>();
        this.indexRuleIndex = this.buildIndexRuleIndex(store);
        this.samplingConfig = new IndexSamplingConfig(Config.defaults());
    }

    private PrimitiveIntObjectMap<List<IndexRule>> buildIndexRuleIndex(SchemaStore schemaStore) {
        PrimitiveIntObjectMap indexRuleIndex = Primitive.intObjectMap();
        for (SchemaRule schemaRule : schemaStore) {
            if (!(schemaRule instanceof IndexRule)) continue;
            IndexRule rule = (IndexRule)schemaRule;
            int propertyId = rule.schema().getPropertyId();
            LinkedList<IndexRule> ruleList = (LinkedList<IndexRule>)indexRuleIndex.get(propertyId);
            if (ruleList == null) {
                ruleList = new LinkedList<IndexRule>();
                indexRuleIndex.put(propertyId, ruleList);
            }
            ruleList.add(rule);
        }
        return indexRuleIndex;
    }

    @Override
    public void close() throws IOException {
        for (IndexReader indexReader : this.readerCache.values()) {
            indexReader.close();
        }
        for (IndexAccessor indexAccessor : this.indexAccessors) {
            indexAccessor.close();
        }
    }

    private IndexRule findIndexRuleWithOneOfLabels(List<IndexRule> indexRules, long[] labelIds) {
        for (long labelId : labelIds) {
            for (IndexRule indexRule : indexRules) {
                if (!SchemaDescriptorPredicates.hasLabel(indexRule, (int)labelId)) continue;
                return indexRule;
            }
        }
        return null;
    }

    private IndexReader getIndexReader(IndexRule rule) throws IOException {
        IndexReader reader = this.readerCache.get(rule);
        if (reader == null) {
            IndexAccessor accessor = this.schemaIndexProvider.getOnlineAccessor(rule.getId(), rule.getIndexDescriptor(), this.samplingConfig);
            this.indexAccessors.add(accessor);
            reader = accessor.newReader();
            this.readerCache.put(rule, reader);
        }
        return reader;
    }

    public Index getAnyIndexOrNull(long[] labelIds, int propertyKeyId) throws IOException {
        List indexRules = (List)this.indexRuleIndex.get(propertyKeyId);
        if (indexRules == null) {
            return null;
        }
        IndexRule rule = this.findIndexRuleWithOneOfLabels(indexRules, labelIds);
        if (rule == null) {
            return null;
        }
        IndexReader reader = this.getIndexReader(rule);
        return (nodeId, propertyValue) -> reader.countIndexedNodes(nodeId, propertyValue) > 0L;
    }

    public boolean hasAnyIndexes() {
        return !this.indexRuleIndex.isEmpty();
    }

    static interface Index {
        public boolean contains(long var1, Object var3) throws IOException;
    }
}

