/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.countStore;

import java.io.IOException;
import java.util.Map;
import org.neo4j.kernel.impl.store.countStore.CountsSnapshot;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyType;
import org.neo4j.kernel.impl.store.counts.keys.IndexSampleKey;
import org.neo4j.kernel.impl.store.counts.keys.IndexStatisticsKey;
import org.neo4j.kernel.impl.store.counts.keys.NodeKey;
import org.neo4j.kernel.impl.store.counts.keys.RelationshipKey;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;

public class CountsSnapshotSerializer {
    public static void serialize(FlushableChannel channel, CountsSnapshot countsSnapshot) throws IOException {
        channel.putLong(countsSnapshot.getTxId());
        channel.putInt(countsSnapshot.getMap().size());
        block7: for (Map.Entry<CountsKey, long[]> pair : countsSnapshot.getMap().entrySet()) {
            CountsKey key = pair.getKey();
            long[] value = pair.getValue();
            switch (key.recordType()) {
                case ENTITY_NODE: {
                    if (value.length != 1) {
                        throw new IllegalArgumentException("CountsKey of type " + (Object)((Object)key.recordType()) + " has an unexpected value.");
                    }
                    NodeKey nodeKey = (NodeKey)key;
                    channel.put(CountsKeyType.ENTITY_NODE.code);
                    channel.putInt(nodeKey.getLabelId());
                    channel.putLong(value[0]);
                    continue block7;
                }
                case ENTITY_RELATIONSHIP: {
                    if (value.length != 1) {
                        throw new IllegalArgumentException("CountsKey of type " + (Object)((Object)key.recordType()) + " has an unexpected value.");
                    }
                    RelationshipKey relationshipKey = (RelationshipKey)key;
                    channel.put(CountsKeyType.ENTITY_RELATIONSHIP.code);
                    channel.putInt(relationshipKey.getStartLabelId());
                    channel.putInt(relationshipKey.getTypeId());
                    channel.putInt(relationshipKey.getEndLabelId());
                    channel.putLong(value[0]);
                    continue block7;
                }
                case INDEX_SAMPLE: {
                    if (value.length != 2) {
                        throw new IllegalArgumentException("CountsKey of type " + (Object)((Object)key.recordType()) + " has an unexpected value.");
                    }
                    IndexSampleKey indexSampleKey = (IndexSampleKey)key;
                    channel.put(CountsKeyType.INDEX_SAMPLE.code);
                    channel.putLong(indexSampleKey.indexId());
                    channel.putLong(value[0]);
                    channel.putLong(value[1]);
                    continue block7;
                }
                case INDEX_STATISTICS: {
                    if (value.length != 2) {
                        throw new IllegalArgumentException("CountsKey of type " + (Object)((Object)key.recordType()) + " has an unexpected value.");
                    }
                    IndexStatisticsKey indexStatisticsKey = (IndexStatisticsKey)key;
                    channel.put(CountsKeyType.INDEX_STATISTICS.code);
                    channel.putLong(indexStatisticsKey.indexId());
                    channel.putLong(value[0]);
                    channel.putLong(value[1]);
                    continue block7;
                }
                case EMPTY: {
                    throw new IllegalArgumentException("CountsKey of type EMPTY cannot be serialized.");
                }
            }
            throw new IllegalArgumentException("The read CountsKey has an unknown type.");
        }
    }
}

