/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.constraints;

import java.util.Iterator;
import java.util.function.BiPredicate;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.SchemaDescriptor;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema_new.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class StandardConstraintSemantics
implements ConstraintSemantics {
    public static final String ERROR_MESSAGE = "Property existence constraint requires Neo4j Enterprise Edition";

    @Override
    public void validateNodePropertyExistenceConstraint(Iterator<Cursor<NodeItem>> allNodes, LabelSchemaDescriptor descriptor, BiPredicate<NodeItem, Integer> hasProperty) throws CreateConstraintFailureException {
        throw this.propertyExistenceConstraintsNotAllowed(descriptor);
    }

    @Override
    public void validateRelationshipPropertyExistenceConstraint(Cursor<RelationshipItem> allRelationships, RelationTypeSchemaDescriptor descriptor, BiPredicate<RelationshipItem, Integer> hasPropertyCheck) throws CreateConstraintFailureException {
        throw this.propertyExistenceConstraintsNotAllowed(descriptor);
    }

    @Override
    public ConstraintDescriptor readConstraint(ConstraintRule rule) {
        ConstraintDescriptor desc = rule.getConstraintDescriptor();
        if (desc.type() == ConstraintDescriptor.Type.UNIQUE) {
            return desc;
        }
        return this.readNonStandardConstraint(rule);
    }

    protected ConstraintDescriptor readNonStandardConstraint(ConstraintRule rule) {
        throw new IllegalStateException(ERROR_MESSAGE);
    }

    private CreateConstraintFailureException propertyExistenceConstraintsNotAllowed(SchemaDescriptor descriptor) {
        return new CreateConstraintFailureException(ConstraintDescriptorFactory.existsForSchema(descriptor), (Throwable)new IllegalStateException(ERROR_MESSAGE));
    }

    @Override
    public ConstraintRule createUniquenessConstraintRule(long ruleId, UniquenessConstraintDescriptor descriptor, long indexId) {
        return ConstraintRule.constraintRule(ruleId, descriptor, indexId);
    }

    @Override
    public ConstraintRule createExistenceConstraint(long ruleId, ConstraintDescriptor descriptor) throws CreateConstraintFailureException {
        throw this.propertyExistenceConstraintsNotAllowed(descriptor.schema());
    }

    @Override
    public TxStateVisitor decorateTxStateVisitor(StoreReadLayer storeLayer, ReadableTransactionState txState, TxStateVisitor visitor) {
        return visitor;
    }
}

