/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.SchemaDescriptor;
import org.neo4j.kernel.api.schema_new.SchemaDescriptorPredicates;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class SchemaCache {
    private final Map<Long, IndexRule> indexRuleById = new HashMap<Long, IndexRule>();
    private final Map<Long, ConstraintRule> constraintRuleById = new HashMap<Long, ConstraintRule>();
    private final Set<ConstraintDescriptor> constraints = new HashSet<ConstraintDescriptor>();
    private final Map<SchemaDescriptor, NewIndexDescriptor> indexDescriptors = new HashMap<SchemaDescriptor, NewIndexDescriptor>();
    private final ConstraintSemantics constraintSemantics;

    public SchemaCache(ConstraintSemantics constraintSemantics, Iterable<SchemaRule> initialRules) {
        this.constraintSemantics = constraintSemantics;
        this.splitUpInitialRules(initialRules);
    }

    private void splitUpInitialRules(Iterable<SchemaRule> initialRules) {
        for (SchemaRule rule : initialRules) {
            this.addSchemaRule(rule);
        }
    }

    public Iterable<IndexRule> indexRules() {
        return this.indexRuleById.values();
    }

    public Iterable<ConstraintRule> constraintRules() {
        return this.constraintRuleById.values();
    }

    public boolean hasConstraintRule(ConstraintDescriptor descriptor) {
        for (ConstraintRule rule : this.constraintRuleById.values()) {
            if (!rule.getConstraintDescriptor().equals(descriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIndexRule(SchemaDescriptor descriptor) {
        for (IndexRule rule : this.indexRuleById.values()) {
            if (!rule.schema().equals(descriptor)) continue;
            return true;
        }
        return false;
    }

    public Iterator<ConstraintDescriptor> constraints() {
        return this.constraints.iterator();
    }

    public Iterator<ConstraintDescriptor> constraintsForLabel(int label) {
        return Iterators.filter(SchemaDescriptorPredicates.hasLabel(label), this.constraints.iterator());
    }

    public Iterator<ConstraintDescriptor> constraintsForRelationshipType(int relTypeId) {
        return Iterators.filter(SchemaDescriptorPredicates.hasRelType(relTypeId), this.constraints.iterator());
    }

    public Iterator<ConstraintDescriptor> constraintsForSchema(SchemaDescriptor descriptor) {
        return Iterators.filter(SchemaDescriptor.equalTo(descriptor), this.constraints.iterator());
    }

    public void addSchemaRule(SchemaRule rule) {
        if (rule instanceof ConstraintRule) {
            ConstraintRule constraintRule = (ConstraintRule)rule;
            this.constraintRuleById.put(constraintRule.getId(), constraintRule);
            this.constraints.add(this.constraintSemantics.readConstraint(constraintRule));
        } else if (rule instanceof IndexRule) {
            IndexRule indexRule = (IndexRule)rule;
            this.indexRuleById.put(indexRule.getId(), indexRule);
            this.indexDescriptors.put(indexRule.schema(), indexRule.getIndexDescriptor());
        }
    }

    public void clear() {
        this.indexRuleById.clear();
        this.constraintRuleById.clear();
        this.constraints.clear();
        this.indexDescriptors.clear();
    }

    public void load(List<SchemaRule> schemaRuleIterator) {
        this.clear();
        for (SchemaRule schemaRule : schemaRuleIterator) {
            this.addSchemaRule(schemaRule);
        }
    }

    public void removeSchemaRule(long id) {
        if (this.constraintRuleById.containsKey(id)) {
            ConstraintRule rule = this.constraintRuleById.remove(id);
            this.constraints.remove(this.constraintSemantics.readConstraint(rule));
        } else if (this.indexRuleById.containsKey(id)) {
            IndexRule rule = this.indexRuleById.remove(id);
            this.indexDescriptors.remove(rule.schema());
        }
    }

    public NewIndexDescriptor indexDescriptor(LabelSchemaDescriptor descriptor) {
        return this.indexDescriptors.get(descriptor);
    }
}

