/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.IndexBelongsToConstraintException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchConstraintException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchIndexException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.SchemaBoundary;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintBoundary;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema_new.constaints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema_new.constaints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema_new.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;

public class DataIntegrityValidatingStatementOperations
implements KeyWriteOperations,
SchemaWriteOperations {
    private final KeyWriteOperations keyWriteDelegate;
    private final SchemaReadOperations schemaReadDelegate;
    private final SchemaWriteOperations schemaWriteDelegate;

    public DataIntegrityValidatingStatementOperations(KeyWriteOperations keyWriteDelegate, SchemaReadOperations schemaReadDelegate, SchemaWriteOperations schemaWriteDelegate) {
        this.keyWriteDelegate = keyWriteDelegate;
        this.schemaReadDelegate = schemaReadDelegate;
        this.schemaWriteDelegate = schemaWriteDelegate;
    }

    @Override
    public int propertyKeyGetOrCreateForName(Statement state, String propertyKey) throws IllegalTokenNameException {
        return this.keyWriteDelegate.propertyKeyGetOrCreateForName(state, this.checkValidTokenName(propertyKey));
    }

    @Override
    public int relationshipTypeGetOrCreateForName(Statement state, String relationshipTypeName) throws IllegalTokenNameException {
        return this.keyWriteDelegate.relationshipTypeGetOrCreateForName(state, this.checkValidTokenName(relationshipTypeName));
    }

    @Override
    public int labelGetOrCreateForName(Statement state, String label) throws IllegalTokenNameException, TooManyLabelsException {
        return this.keyWriteDelegate.labelGetOrCreateForName(state, this.checkValidTokenName(label));
    }

    @Override
    public void labelCreateForName(KernelStatement state, String labelName, int id) throws IllegalTokenNameException, TooManyLabelsException {
        this.keyWriteDelegate.labelCreateForName(state, labelName, id);
    }

    @Override
    public void propertyKeyCreateForName(KernelStatement state, String propertyKeyName, int id) throws IllegalTokenNameException {
        this.keyWriteDelegate.propertyKeyCreateForName(state, propertyKeyName, id);
    }

    @Override
    public void relationshipTypeCreateForName(KernelStatement state, String relationshipTypeName, int id) throws IllegalTokenNameException {
        this.keyWriteDelegate.relationshipTypeCreateForName(state, relationshipTypeName, id);
    }

    @Override
    public NewIndexDescriptor indexCreate(KernelStatement state, NodePropertyDescriptor descriptor) throws AlreadyIndexedException, AlreadyConstrainedException {
        this.checkIndexExistence(state, SchemaKernelException.OperationContext.INDEX_CREATION, descriptor);
        return this.schemaWriteDelegate.indexCreate(state, descriptor);
    }

    @Override
    public void indexDrop(KernelStatement state, NewIndexDescriptor index) throws DropIndexFailureException {
        try {
            NewIndexDescriptor existingIndex = this.schemaReadDelegate.indexGetForLabelAndPropertyKey(state, SchemaBoundary.map(index.schema()));
            if (existingIndex == null) {
                throw new NoSuchIndexException(index.schema());
            }
            if (existingIndex.type() == NewIndexDescriptor.Type.UNIQUE) {
                throw new IndexBelongsToConstraintException(index.schema());
            }
        }
        catch (IndexBelongsToConstraintException | NoSuchIndexException e) {
            throw new DropIndexFailureException(index.schema(), e);
        }
        this.schemaWriteDelegate.indexDrop(state, index);
    }

    @Override
    public void uniqueIndexDrop(KernelStatement state, NewIndexDescriptor index) throws DropIndexFailureException {
        this.schemaWriteDelegate.uniqueIndexDrop(state, index);
    }

    @Override
    public UniquenessConstraintDescriptor uniquePropertyConstraintCreate(KernelStatement state, LabelSchemaDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException, AlreadyIndexedException {
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema(descriptor);
        this.assertConstraintDoesNotExist(state, constraint);
        this.checkIndexExistence(state, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, SchemaBoundary.map(descriptor));
        return this.schemaWriteDelegate.uniquePropertyConstraintCreate(state, descriptor);
    }

    @Override
    public NodeExistenceConstraintDescriptor nodePropertyExistenceConstraintCreate(KernelStatement state, LabelSchemaDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException {
        NodeExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForSchema(descriptor);
        this.assertConstraintDoesNotExist(state, constraint);
        return this.schemaWriteDelegate.nodePropertyExistenceConstraintCreate(state, descriptor);
    }

    @Override
    public RelExistenceConstraintDescriptor relationshipPropertyExistenceConstraintCreate(KernelStatement state, RelationTypeSchemaDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException {
        RelExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForSchema(descriptor);
        this.assertConstraintDoesNotExist(state, constraint);
        return this.schemaWriteDelegate.relationshipPropertyExistenceConstraintCreate(state, descriptor);
    }

    @Override
    public void constraintDrop(KernelStatement state, ConstraintDescriptor descriptor) throws DropConstraintFailureException {
        try {
            this.assertConstraintExists(state, descriptor);
        }
        catch (NoSuchConstraintException e) {
            throw new DropConstraintFailureException(ConstraintBoundary.map(descriptor), (Throwable)e);
        }
        this.schemaWriteDelegate.constraintDrop(state, descriptor);
    }

    private void checkIndexExistence(KernelStatement state, SchemaKernelException.OperationContext context, NodePropertyDescriptor descriptor) throws AlreadyIndexedException, AlreadyConstrainedException {
        NewIndexDescriptor existingIndex = this.schemaReadDelegate.indexGetForLabelAndPropertyKey(state, descriptor);
        if (existingIndex != null) {
            if (existingIndex.type() == NewIndexDescriptor.Type.UNIQUE) {
                throw new AlreadyConstrainedException(new UniquenessConstraint(descriptor), context, new StatementTokenNameLookup(state.readOperations()));
            }
            throw new AlreadyIndexedException(descriptor, context);
        }
    }

    private String checkValidTokenName(String name) throws IllegalTokenNameException {
        if (name == null || name.isEmpty()) {
            throw new IllegalTokenNameException(name);
        }
        return name;
    }

    private void assertConstraintDoesNotExist(KernelStatement state, ConstraintDescriptor constraint) throws AlreadyConstrainedException {
        if (this.schemaReadDelegate.constraintExists(state, constraint)) {
            throw new AlreadyConstrainedException(ConstraintBoundary.map(constraint), SchemaKernelException.OperationContext.CONSTRAINT_CREATION, new StatementTokenNameLookup(state.readOperations()));
        }
    }

    private void assertConstraintExists(KernelStatement state, ConstraintDescriptor constraint) throws NoSuchConstraintException {
        if (!this.schemaReadDelegate.constraintExists(state, constraint)) {
            throw new NoSuchConstraintException(ConstraintBoundary.map(constraint));
        }
    }
}

