/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension.dependency;

import java.util.ArrayList;
import java.util.Objects;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;

public class NamedLabelScanStoreSelectionStrategy
implements DependencyResolver.SelectionStrategy {
    private final String specificallyConfigured;

    public NamedLabelScanStoreSelectionStrategy(Config config) {
        this.specificallyConfigured = config.get(GraphDatabaseSettings.label_index);
        Objects.requireNonNull(this.specificallyConfigured);
    }

    public <T> T select(Class<T> type, Iterable<T> candidates) throws IllegalArgumentException {
        if (!type.equals(LabelScanStoreProvider.class)) {
            throw new IllegalArgumentException("Was expecting " + LabelScanStoreProvider.class);
        }
        ArrayList<String> candidateNames = new ArrayList<String>();
        for (T candidate : candidates) {
            LabelScanStoreProvider provider = (LabelScanStoreProvider)((Object)candidate);
            String candidateName = provider.getName();
            candidateNames.add(candidateName);
            if (!this.specificallyConfigured.equalsIgnoreCase(candidateName)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("Configured label index '" + this.specificallyConfigured + "', but couldn't find it among candidates " + candidateNames);
    }
}

