/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema_new;

import java.util.Arrays;

public class OrderedPropertyValues {
    private final Object[] values;

    public static OrderedPropertyValues of(Object ... values) {
        return new OrderedPropertyValues(values);
    }

    private OrderedPropertyValues(Object[] values) {
        this.values = values;
    }

    public Object[] values() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderedPropertyValues that = (OrderedPropertyValues)o;
        return Arrays.deepEquals(this.values, that.values);
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.values);
    }

    public int size() {
        return this.values.length;
    }

    public Object getSinglePropertyValue() {
        assert (this.values.length == 1) : "Assumed single property but had " + this.values.length;
        return this.values[0];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sep = "( ";
        for (Object value : this.values) {
            sb.append(sep);
            sep = ", ";
            sb.append(OrderedPropertyValues.quote(value));
        }
        sb.append(" )");
        return sb.toString();
    }

    public static String quote(Object propertyValue) {
        if (propertyValue instanceof String) {
            return String.format("'%s'", propertyValue);
        }
        if (propertyValue.getClass().isArray()) {
            Class<?> type = propertyValue.getClass().getComponentType();
            if (type == Boolean.TYPE) {
                return Arrays.toString((boolean[])propertyValue);
            }
            if (type == Byte.TYPE) {
                return Arrays.toString((byte[])propertyValue);
            }
            if (type == Short.TYPE) {
                return Arrays.toString((short[])propertyValue);
            }
            if (type == Character.TYPE) {
                return Arrays.toString((char[])propertyValue);
            }
            if (type == Integer.TYPE) {
                return Arrays.toString((int[])propertyValue);
            }
            if (type == Long.TYPE) {
                return Arrays.toString((long[])propertyValue);
            }
            if (type == Float.TYPE) {
                return Arrays.toString((float[])propertyValue);
            }
            if (type == Double.TYPE) {
                return Arrays.toString((double[])propertyValue);
            }
            return Arrays.toString((Object[])propertyValue);
        }
        return String.valueOf(propertyValue);
    }
}

