/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import org.neo4j.kernel.api.schema_new.SchemaUtil;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.impl.api.index.UpdateMode;

public class IndexEntryUpdate {
    private final long entityId;
    private final UpdateMode updateMode;
    private final Object[] before;
    private Object[] values;
    private NewIndexDescriptor descriptor;

    private IndexEntryUpdate(long entityId, NewIndexDescriptor descriptor, UpdateMode updateMode, Object ... values) {
        this.entityId = entityId;
        this.descriptor = descriptor;
        this.before = null;
        this.values = values;
        this.updateMode = updateMode;
    }

    private IndexEntryUpdate(long entityId, NewIndexDescriptor descriptor, UpdateMode updateMode, Object[] before, Object[] values) {
        this.entityId = entityId;
        this.descriptor = descriptor;
        this.before = before;
        this.values = values;
        this.updateMode = updateMode;
    }

    public final long getEntityId() {
        return this.entityId;
    }

    public UpdateMode updateMode() {
        return this.updateMode;
    }

    public NewIndexDescriptor descriptor() {
        return this.descriptor;
    }

    public Object[] values() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexEntryUpdate that = (IndexEntryUpdate)o;
        if (this.entityId != that.entityId) {
            return false;
        }
        if (this.updateMode != that.updateMode) {
            return false;
        }
        if (!Arrays.deepEquals(this.before, that.before)) {
            return false;
        }
        if (!Arrays.deepEquals(this.values, that.values)) {
            return false;
        }
        return this.descriptor != null ? this.descriptor.equals(that.descriptor) : that.descriptor == null;
    }

    public int hashCode() {
        int result = (int)(this.entityId ^ this.entityId >>> 32);
        result = 31 * result + (this.updateMode != null ? this.updateMode.hashCode() : 0);
        result = 31 * result + Arrays.deepHashCode(this.before);
        result = 31 * result + Arrays.deepHashCode(this.values);
        result = 31 * result + (this.descriptor != null ? this.descriptor.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("IndexEntryUpdate[id=%d, mode=%s, %s, values=%s]", new Object[]{this.entityId, this.updateMode, this.descriptor().userDescription(SchemaUtil.idTokenNameLookup), Arrays.toString(this.values)});
    }

    public static IndexEntryUpdate add(long nodeId, NewIndexDescriptor descriptor, Object ... values) {
        return new IndexEntryUpdate(nodeId, descriptor, UpdateMode.ADDED, values);
    }

    public static IndexEntryUpdate remove(long nodeId, NewIndexDescriptor descriptor, Object ... values) {
        return new IndexEntryUpdate(nodeId, descriptor, UpdateMode.REMOVED, values);
    }

    public static IndexEntryUpdate change(long nodeId, NewIndexDescriptor descriptor, Object before, Object after) {
        return new IndexEntryUpdate(nodeId, descriptor, UpdateMode.CHANGED, new Object[]{before}, new Object[]{after});
    }

    public static IndexEntryUpdate change(long nodeId, NewIndexDescriptor descriptor, Object[] before, Object[] after) {
        return new IndexEntryUpdate(nodeId, descriptor, UpdateMode.CHANGED, before, after);
    }

    public Object[] beforeValues() {
        if (this.before == null) {
            throw new UnsupportedOperationException("beforeValues is only valid for `UpdateMode.CHANGED");
        }
        return this.before;
    }
}

