/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.index;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.OrderedPropertyValues;
import org.neo4j.kernel.api.schema_new.SchemaUtil;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;

public class IndexEntryConflictException
extends Exception {
    private final OrderedPropertyValues propertyValues;
    private final long addedNodeId;
    private final long existingNodeId;

    public IndexEntryConflictException(long existingNodeId, long addedNodeId, Object propertyValue) {
        this(existingNodeId, addedNodeId, OrderedPropertyValues.of(propertyValue));
    }

    public IndexEntryConflictException(long existingNodeId, long addedNodeId, OrderedPropertyValues propertyValues) {
        super(String.format("Both node %d and node %d share the property value %s", existingNodeId, addedNodeId, propertyValues));
        this.existingNodeId = existingNodeId;
        this.addedNodeId = addedNodeId;
        this.propertyValues = propertyValues;
    }

    public RuntimeException notAllowed(NewIndexDescriptor descriptor) {
        return new IllegalStateException(String.format("Index for (%s) should not require unique values.", descriptor.userDescription(SchemaUtil.idTokenNameLookup)), this);
    }

    public String evidenceMessage(TokenNameLookup tokenNameLookup, LabelSchemaDescriptor schema) {
        assert (schema.getPropertyIds().length == this.propertyValues.size());
        String labelName = tokenNameLookup.labelGetName(schema.getLabelId());
        if (this.addedNodeId == -1L) {
            return String.format("Node(%d) already exists with label `%s` and %s", this.existingNodeId, labelName, this.propertyString(tokenNameLookup, schema.getPropertyIds()));
        }
        return String.format("Both Node(%d) and Node(%d) have the label `%s` and %s", this.existingNodeId, this.addedNodeId, labelName, this.propertyString(tokenNameLookup, schema.getPropertyIds()));
    }

    public OrderedPropertyValues getPropertyValues() {
        return this.propertyValues;
    }

    public Object getSinglePropertyValue() {
        return this.propertyValues.getSinglePropertyValue();
    }

    public long getAddedNodeId() {
        return this.addedNodeId;
    }

    public long getExistingNodeId() {
        return this.existingNodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexEntryConflictException that = (IndexEntryConflictException)o;
        return this.addedNodeId == that.addedNodeId && this.existingNodeId == that.existingNodeId && !(this.propertyValues == null ? that.propertyValues != null : !this.propertyValues.equals(that.propertyValues));
    }

    public int hashCode() {
        int result = this.propertyValues != null ? this.propertyValues.hashCode() : 0;
        result = 31 * result + (int)(this.addedNodeId ^ this.addedNodeId >>> 32);
        result = 31 * result + (int)(this.existingNodeId ^ this.existingNodeId >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "IndexEntryConflictException{propertyValues=" + this.propertyValues + ", addedNodeId=" + this.addedNodeId + ", existingNodeId=" + this.existingNodeId + '}';
    }

    private String propertyString(TokenNameLookup tokenNameLookup, int[] propertyIds) {
        StringBuilder sb = new StringBuilder();
        String sep = propertyIds.length > 1 ? "properties " : "property ";
        for (int i = 0; i < propertyIds.length; ++i) {
            sb.append(sep);
            sep = ", ";
            sb.append('`');
            sb.append(tokenNameLookup.propertyKeyGetName(propertyIds[i]));
            sb.append("` = ");
            sb.append(OrderedPropertyValues.quote(this.propertyValues.values()[i]));
        }
        return sb.toString();
    }
}

