/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategies;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.spi.SimpleKernelContext;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.store.BatchingIdGeneratorFactory;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;
import org.neo4j.unsafe.impl.batchimport.store.io.IoTracer;

public class BatchingNeoStores
implements AutoCloseable {
    private final FileSystemAbstraction fileSystem;
    private final BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyRepository;
    private final BatchingTokenRepository.BatchingLabelTokenRepository labelRepository;
    private final BatchingTokenRepository.BatchingRelationshipTypeTokenRepository relationshipTypeRepository;
    private final LogProvider logProvider;
    private final File storeDir;
    private final Config neo4jConfig;
    private final PageCache pageCache;
    private final NeoStores neoStores;
    private final LifeSupport life = new LifeSupport();
    private final IoTracer ioTracer;
    private final RecordFormats recordFormats;
    private final NeoStores temporaryNeoStores;
    private boolean externalPageCache;

    private BatchingNeoStores(FileSystemAbstraction fileSystem, PageCache pageCache, File storeDir, RecordFormats recordFormats, Config neo4jConfig, LogService logService, AdditionalInitialIds initialIds, boolean externalPageCache, IoTracer ioTracer) {
        this.fileSystem = fileSystem;
        this.recordFormats = recordFormats;
        this.logProvider = logService.getInternalLogProvider();
        this.storeDir = storeDir;
        this.neo4jConfig = neo4jConfig;
        this.pageCache = pageCache;
        this.ioTracer = ioTracer;
        this.externalPageCache = externalPageCache;
        this.neoStores = this.newStoreFactory("neostore", new OpenOption[0]).openAllNeoStores(true);
        if (this.alreadyContainsData(this.neoStores)) {
            this.neoStores.close();
            IllegalStateException ise = new IllegalStateException(storeDir + " already contains data, cannot do import here");
            if (!externalPageCache) {
                try {
                    pageCache.close();
                }
                catch (Exception e) {
                    ise.addSuppressed(e);
                }
            }
            throw ise;
        }
        try {
            this.neoStores.rebuildCountStoreIfNeeded();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
        this.neoStores.getMetaDataStore().setLastCommittedAndClosedTransactionId(initialIds.lastCommittedTransactionId(), initialIds.lastCommittedTransactionChecksum(), 0L, initialIds.lastCommittedTransactionLogByteOffset(), initialIds.lastCommittedTransactionLogVersion());
        this.propertyKeyRepository = new BatchingTokenRepository.BatchingPropertyKeyTokenRepository(this.neoStores.getPropertyKeyTokenStore());
        this.labelRepository = new BatchingTokenRepository.BatchingLabelTokenRepository(this.neoStores.getLabelTokenStore());
        this.relationshipTypeRepository = new BatchingTokenRepository.BatchingRelationshipTypeTokenRepository(this.neoStores.getRelationshipTypeTokenStore());
        this.temporaryNeoStores = this.newStoreFactory("temp.neostore", StandardOpenOption.DELETE_ON_CLOSE).openNeoStores(true, StoreType.RELATIONSHIP_GROUP);
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency(this.neo4jConfig);
        dependencies.satisfyDependency(fileSystem);
        dependencies.satisfyDependency(this);
        dependencies.satisfyDependency(logService);
        dependencies.satisfyDependency(IndexStoreView.EMPTY);
        SimpleKernelContext kernelContext = new SimpleKernelContext(storeDir, DatabaseInfo.UNKNOWN, dependencies);
        KernelExtensions extensions = (KernelExtensions)this.life.add((Lifecycle)new KernelExtensions(kernelContext, Service.load(KernelExtensionFactory.class), dependencies, UnsatisfiedDependencyStrategies.ignore()));
        this.life.start();
    }

    public static BatchingNeoStores batchingNeoStores(FileSystemAbstraction fileSystem, File storeDir, RecordFormats recordFormats, Configuration config, LogService logService, AdditionalInitialIds initialIds, Config dbConfig) {
        Config neo4jConfig = BatchingNeoStores.getNeo4jConfig(config, dbConfig);
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer();
        PageCache pageCache = BatchingNeoStores.createPageCache(fileSystem, neo4jConfig, logService.getInternalLogProvider(), (PageCacheTracer)tracer);
        BatchingNeoStores batchingNeoStores = new BatchingNeoStores(fileSystem, pageCache, storeDir, recordFormats, neo4jConfig, logService, initialIds, false, () -> ((PageCacheTracer)tracer).bytesWritten());
        return batchingNeoStores;
    }

    public static BatchingNeoStores batchingNeoStoresWithExternalPageCache(FileSystemAbstraction fileSystem, PageCache pageCache, PageCacheTracer tracer, File storeDir, RecordFormats recordFormats, Configuration config, LogService logService, AdditionalInitialIds initialIds, Config dbConfig) {
        Config neo4jConfig = BatchingNeoStores.getNeo4jConfig(config, dbConfig);
        BatchingNeoStores batchingNeoStores = new BatchingNeoStores(fileSystem, pageCache, storeDir, recordFormats, neo4jConfig, logService, initialIds, true, () -> ((PageCacheTracer)tracer).bytesWritten());
        return batchingNeoStores;
    }

    protected static Config getNeo4jConfig(Configuration config, Config dbConfig) {
        return dbConfig.with(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.dense_node_threshold.name(), String.valueOf(config.denseNodeThreshold()), GraphDatabaseSettings.pagecache_memory.name(), String.valueOf(config.pageCacheMemory())}));
    }

    private static PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, LogProvider log, PageCacheTracer tracer) {
        return new ConfiguringPageCacheFactory(fileSystem, config, tracer, log.getLog(BatchingNeoStores.class)).getOrCreatePageCache();
    }

    private boolean alreadyContainsData(NeoStores neoStores) {
        return neoStores.getNodeStore().getHighId() > 0L || neoStores.getRelationshipStore().getHighId() > 0L;
    }

    private StoreFactory newStoreFactory(String name, OpenOption ... openOptions) {
        return new StoreFactory(this.storeDir, name, this.neo4jConfig, new BatchingIdGeneratorFactory(this.fileSystem), this.pageCache, this.fileSystem, this.recordFormats, this.logProvider, openOptions);
    }

    public RecordStore<RelationshipGroupRecord> getTemporaryRelationshipGroupStore() {
        return this.temporaryNeoStores.getRelationshipGroupStore();
    }

    public IoTracer getIoTracer() {
        return this.ioTracer;
    }

    public NodeStore getNodeStore() {
        return this.neoStores.getNodeStore();
    }

    public PropertyStore getPropertyStore() {
        return this.neoStores.getPropertyStore();
    }

    public BatchingTokenRepository.BatchingPropertyKeyTokenRepository getPropertyKeyRepository() {
        return this.propertyKeyRepository;
    }

    public BatchingTokenRepository.BatchingLabelTokenRepository getLabelRepository() {
        return this.labelRepository;
    }

    public BatchingTokenRepository.BatchingRelationshipTypeTokenRepository getRelationshipTypeRepository() {
        return this.relationshipTypeRepository;
    }

    public RelationshipStore getRelationshipStore() {
        return this.neoStores.getRelationshipStore();
    }

    public RecordStore<RelationshipGroupRecord> getRelationshipGroupStore() {
        return this.neoStores.getRelationshipGroupStore();
    }

    public CountsTracker getCountsStore() {
        return this.neoStores.getCounts();
    }

    @Override
    public void close() throws IOException {
        this.propertyKeyRepository.close();
        this.labelRepository.close();
        this.relationshipTypeRepository.close();
        this.life.shutdown();
        this.neoStores.close();
        this.temporaryNeoStores.close();
        if (!this.externalPageCache) {
            this.pageCache.close();
        }
    }

    public long getLastCommittedTransactionId() {
        return this.neoStores.getMetaDataStore().getLastCommittedTransactionId();
    }

    public NeoStores getNeoStores() {
        return this.neoStores;
    }
}

