/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.function.Supplier;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.schema_new.index.IndexBoundary;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.store.AllIdIterator;
import org.neo4j.kernel.impl.api.store.StoreIteratorRelationshipCursor;
import org.neo4j.kernel.impl.api.store.StoreSingleNodeCursor;
import org.neo4j.kernel.impl.api.store.StoreSingleRelationshipCursor;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public class StoreStatement
implements StorageStatement {
    private final InstanceCache<StoreSingleNodeCursor> singleNodeCursor;
    private final InstanceCache<StoreSingleRelationshipCursor> singleRelationshipCursor;
    private final InstanceCache<StoreIteratorRelationshipCursor> iteratorRelationshipCursor;
    private final NeoStores neoStores;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final Supplier<IndexReaderFactory> indexReaderFactorySupplier;
    private final RecordCursors recordCursors;
    private final Supplier<LabelScanReader> labelScanStore;
    private IndexReaderFactory indexReaderFactory;
    private LabelScanReader labelScanReader;
    private boolean acquired;
    private boolean closed;

    public StoreStatement(final NeoStores neoStores, Supplier<IndexReaderFactory> indexReaderFactory, Supplier<LabelScanReader> labelScanReaderSupplier, final LockService lockService) {
        this.neoStores = neoStores;
        this.indexReaderFactorySupplier = indexReaderFactory;
        this.labelScanStore = labelScanReaderSupplier;
        this.nodeStore = neoStores.getNodeStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.recordCursors = new RecordCursors(neoStores);
        this.singleNodeCursor = new InstanceCache<StoreSingleNodeCursor>(){

            @Override
            protected StoreSingleNodeCursor create() {
                return new StoreSingleNodeCursor((NodeRecord)StoreStatement.this.nodeStore.newRecord(), neoStores, this, StoreStatement.this.recordCursors, lockService);
            }
        };
        this.singleRelationshipCursor = new InstanceCache<StoreSingleRelationshipCursor>(){

            @Override
            protected StoreSingleRelationshipCursor create() {
                return new StoreSingleRelationshipCursor((RelationshipRecord)StoreStatement.this.relationshipStore.newRecord(), this, StoreStatement.this.recordCursors, lockService);
            }
        };
        this.iteratorRelationshipCursor = new InstanceCache<StoreIteratorRelationshipCursor>(){

            @Override
            protected StoreIteratorRelationshipCursor create() {
                return new StoreIteratorRelationshipCursor((RelationshipRecord)StoreStatement.this.relationshipStore.newRecord(), this, StoreStatement.this.recordCursors, lockService);
            }
        };
    }

    @Override
    public void acquire() {
        assert (!this.closed);
        assert (!this.acquired);
        this.acquired = true;
    }

    @Override
    public Cursor<NodeItem> acquireSingleNodeCursor(long nodeId) {
        this.neoStores.assertOpen();
        return this.singleNodeCursor.get().init(nodeId);
    }

    @Override
    public Cursor<RelationshipItem> acquireSingleRelationshipCursor(long relId) {
        this.neoStores.assertOpen();
        return this.singleRelationshipCursor.get().init(relId);
    }

    @Override
    public Cursor<RelationshipItem> relationshipsGetAllCursor() {
        this.neoStores.assertOpen();
        return this.iteratorRelationshipCursor.get().init((PrimitiveLongIterator)new AllIdIterator(this.relationshipStore));
    }

    @Override
    public void release() {
        assert (!this.closed);
        assert (this.acquired);
        this.closeSchemaResources();
        this.acquired = false;
    }

    @Override
    public void close() {
        assert (!this.closed);
        this.closeSchemaResources();
        this.recordCursors.close();
        this.closed = true;
    }

    private void closeSchemaResources() {
        if (this.indexReaderFactory != null) {
            this.indexReaderFactory.close();
        }
        if (this.labelScanReader != null) {
            this.labelScanReader.close();
            this.labelScanReader = null;
        }
    }

    @Override
    public LabelScanReader getLabelScanReader() {
        return this.labelScanReader != null ? this.labelScanReader : (this.labelScanReader = this.labelScanStore.get());
    }

    private IndexReaderFactory indexReaderFactory() {
        return this.indexReaderFactory != null ? this.indexReaderFactory : (this.indexReaderFactory = this.indexReaderFactorySupplier.get());
    }

    @Override
    public IndexReader getIndexReader(NewIndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexReaderFactory().newReader(IndexBoundary.map(descriptor));
    }

    @Override
    public IndexReader getFreshIndexReader(NewIndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexReaderFactory().newUnCachedReader(IndexBoundary.map(descriptor));
    }

    @Override
    public RecordCursors recordCursors() {
        return this.recordCursors;
    }
}

