/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.function.Predicate;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.impl.api.state.StateDefaults;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;

public abstract class LabelState {
    private static final LabelState DEFAULT = new LabelState(){

        @Override
        public ReadableDiffSets<Long> nodeDiffSets() {
            return ReadableDiffSets.Empty.instance();
        }

        @Override
        public ReadableDiffSets<NewIndexDescriptor> indexChanges(NewIndexDescriptor.Filter indexType) {
            return ReadableDiffSets.Empty.instance();
        }

        @Override
        public ReadableDiffSets<NodePropertyConstraint> nodeConstraintsChanges() {
            return ReadableDiffSets.Empty.instance();
        }
    };

    public abstract ReadableDiffSets<Long> nodeDiffSets();

    public abstract ReadableDiffSets<NewIndexDescriptor> indexChanges(NewIndexDescriptor.Filter var1);

    public abstract ReadableDiffSets<NodePropertyConstraint> nodeConstraintsChanges();

    private LabelState() {
    }

    static abstract class Defaults
    extends StateDefaults<Integer, LabelState, Mutable> {
        Defaults() {
        }

        @Override
        Mutable createValue(Integer key, TxState state) {
            return new Mutable(key);
        }

        @Override
        LabelState defaultValue() {
            return DEFAULT;
        }
    }

    public static class Mutable
    extends LabelState {
        private DiffSets<Long> nodeDiffSets;
        private DiffSets<NewIndexDescriptor> indexChanges;
        private DiffSets<NodePropertyConstraint> nodeConstraintsChanges;
        private final int labelId;

        private Mutable(int labelId) {
            this.labelId = labelId;
        }

        public int getLabelId() {
            return this.labelId;
        }

        @Override
        public ReadableDiffSets<Long> nodeDiffSets() {
            return ReadableDiffSets.Empty.ifNull(this.nodeDiffSets);
        }

        public DiffSets<Long> getOrCreateNodeDiffSets() {
            if (this.nodeDiffSets == null) {
                this.nodeDiffSets = new DiffSets();
            }
            return this.nodeDiffSets;
        }

        @Override
        public ReadableDiffSets<NewIndexDescriptor> indexChanges(NewIndexDescriptor.Filter indexType) {
            return ReadableDiffSets.Empty.ifNull(this.indexChanges).filterAdded((Predicate)indexType);
        }

        public DiffSets<NewIndexDescriptor> getOrCreateIndexChanges() {
            if (this.indexChanges == null) {
                this.indexChanges = new DiffSets();
            }
            return this.indexChanges;
        }

        @Override
        public ReadableDiffSets<NodePropertyConstraint> nodeConstraintsChanges() {
            return ReadableDiffSets.Empty.ifNull(this.nodeConstraintsChanges);
        }

        public DiffSets<NodePropertyConstraint> getOrCreateConstraintsChanges() {
            if (this.nodeConstraintsChanges == null) {
                this.nodeConstraintsChanges = new DiffSets();
            }
            return this.nodeConstraintsChanges;
        }
    }
}

