/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import java.util.function.Consumer;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.cursor.EntityItemHelper;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.txstate.NodeState;

public class TxSingleNodeCursor
extends EntityItemHelper
implements Cursor<NodeItem>,
NodeItem {
    private final TransactionState state;
    private final Consumer<TxSingleNodeCursor> cache;
    private long id = -1L;
    private Cursor<NodeItem> cursor;
    private NodeState nodeState;
    private boolean nodeIsAddedInThisTx;

    public TxSingleNodeCursor(TransactionState state, Consumer<TxSingleNodeCursor> cache) {
        this.state = state;
        this.cache = cache;
    }

    public TxSingleNodeCursor init(Cursor<NodeItem> nodeCursor, long nodeId) {
        this.id = nodeId;
        this.cursor = nodeCursor;
        this.nodeIsAddedInThisTx = this.state.nodeIsAddedInThisTx(this.id);
        return this;
    }

    public NodeItem get() {
        if (this.id == -1L) {
            throw new IllegalStateException();
        }
        return this;
    }

    public boolean next() {
        if (this.id == -1L) {
            return false;
        }
        if (this.state.nodeIsDeletedInThisTx(this.id)) {
            this.id = -1L;
            return false;
        }
        if (this.cursor.next() || this.nodeIsAddedInThisTx) {
            this.nodeIsAddedInThisTx = false;
            this.nodeState = this.state.getNodeState(this.id);
            return true;
        }
        this.id = -1L;
        this.nodeState = null;
        return false;
    }

    public void close() {
        this.cursor.close();
        this.cursor = null;
        this.cache.accept(this);
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public PrimitiveIntSet labels() {
        return this.state.augmentLabels(this.nodeIsAddedInThisTx ? Primitive.intSet() : ((NodeItem)this.cursor.get()).labels(), this.nodeState);
    }

    @Override
    public boolean hasLabel(int labelId) {
        if (this.nodeIsAddedInThisTx || this.nodeState.labelDiffSets().getRemoved().contains(labelId)) {
            return false;
        }
        if (this.nodeState.labelDiffSets().getAdded().contains(labelId)) {
            return true;
        }
        return ((NodeItem)this.cursor.get()).hasLabel(labelId);
    }

    @Override
    public Cursor<PropertyItem> properties() {
        return this.state.augmentPropertyCursor((Cursor<PropertyItem>)(this.nodeIsAddedInThisTx ? Cursors.empty() : ((NodeItem)this.cursor.get()).properties()), this.nodeState);
    }

    @Override
    public Cursor<PropertyItem> property(int propertyKeyId) {
        Cursor cursor = this.nodeIsAddedInThisTx ? Cursors.empty() : ((NodeItem)this.cursor.get()).property(propertyKeyId);
        return this.state.augmentSinglePropertyCursor(cursor, this.nodeState, propertyKeyId);
    }

    @Override
    public Cursor<RelationshipItem> relationships(Direction direction, int ... relTypes) {
        Cursor cursor = this.nodeIsAddedInThisTx ? Cursors.empty() : ((NodeItem)this.cursor.get()).relationships(direction, relTypes);
        return this.state.augmentNodeRelationshipCursor(cursor, this.nodeState, direction, relTypes);
    }

    @Override
    public Cursor<RelationshipItem> relationships(Direction direction) {
        Cursor cursor = this.nodeIsAddedInThisTx ? Cursors.empty() : ((NodeItem)this.cursor.get()).relationships(direction);
        return this.state.augmentNodeRelationshipCursor(cursor, this.nodeState, direction, null);
    }

    @Override
    public PrimitiveIntSet relationshipTypes() {
        if (this.nodeIsAddedInThisTx) {
            return this.nodeState.relationshipTypes();
        }
        PrimitiveIntSet types = this.nodeState.relationshipTypes();
        types.addAll(PrimitiveIntCollections.filter((PrimitiveIntIterator)((NodeItem)this.cursor.get()).relationshipTypes().iterator(), current -> !types.contains(current) && this.degree(Direction.BOTH, current) > 0));
        return types;
    }

    @Override
    public int degree(Direction direction) {
        return this.nodeState.augmentDegree(direction, this.nodeIsAddedInThisTx ? 0 : ((NodeItem)this.cursor.get()).degree(direction));
    }

    @Override
    public int degree(Direction direction, int relType) {
        int degree = this.nodeIsAddedInThisTx ? 0 : ((NodeItem)this.cursor.get()).degree(direction, relType);
        return this.nodeState.augmentDegree(direction, degree, relType);
    }

    @Override
    public boolean isDense() {
        return ((NodeItem)this.cursor.get()).isDense();
    }

    @Override
    public long nextGroupId() {
        return this.nodeIsAddedInThisTx ? Record.NO_NEXT_RELATIONSHIP.longValue() : ((NodeItem)this.cursor.get()).nextGroupId();
    }
}

