/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema_new.constaints;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.schema_new.SchemaDescriptor;

public class ConstraintDescriptor
implements SchemaDescriptor.Supplier {
    private final SchemaDescriptor schema;
    private final Type type;

    ConstraintDescriptor(SchemaDescriptor schema, Type type) {
        this.schema = schema;
        this.type = type;
    }

    @Override
    public SchemaDescriptor schema() {
        return this.schema;
    }

    public Type type() {
        return this.type;
    }

    public String userDescription(TokenNameLookup tokenNameLookup) {
        return String.format("Constraint( %s, %s )", this.type.name(), this.schema.userDescription(tokenNameLookup));
    }

    public boolean isSame(Supplier supplier) {
        return this.equals(supplier.getConstraintDescriptor());
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof ConstraintDescriptor) {
            ConstraintDescriptor that = (ConstraintDescriptor)o;
            return this.type() == that.type() && this.schema().equals(that.schema());
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode() & this.schema.hashCode();
    }

    public static interface Supplier {
        public ConstraintDescriptor getConstraintDescriptor();
    }

    public static enum Type {
        UNIQUE,
        EXISTS;

    }
}

