/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.schema.RelationshipPropertyDescriptor;

public class RelationshipPropertyExistenceConstraintVerificationFailedKernelException
extends ConstraintVerificationFailedKernelException {
    private final RelationshipPropertyExistenceConstraint constraint;
    private final long relationshipId;

    public RelationshipPropertyExistenceConstraintVerificationFailedKernelException(RelationshipPropertyExistenceConstraint constraint, long relationshipId) {
        super(constraint);
        this.constraint = constraint;
        this.relationshipId = relationshipId;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        RelationshipPropertyDescriptor descriptor = this.constraint.descriptor();
        return String.format("Relationship(%s) with type `%s` has no value for property `%s`", this.relationshipId, tokenNameLookup.relationshipTypeGetName(descriptor.getRelationshipTypeId()), tokenNameLookup.propertyKeyGetName(descriptor.getPropertyKeyId()));
    }

    @Override
    public RelationshipPropertyExistenceConstraint constraint() {
        return this.constraint;
    }
}

