/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.index;

import java.util.Arrays;
import org.neo4j.kernel.api.schema_new.SchemaUtil;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;

public abstract class IndexEntryConflictException
extends Exception {
    public IndexEntryConflictException(String message) {
        super(message);
    }

    protected static String quote(Object propertyValue) {
        if (propertyValue instanceof String) {
            return String.format("'%s'", propertyValue);
        }
        if (propertyValue.getClass().isArray()) {
            Class<?> type = propertyValue.getClass().getComponentType();
            if (type == Boolean.TYPE) {
                return Arrays.toString((boolean[])propertyValue);
            }
            if (type == Byte.TYPE) {
                return Arrays.toString((byte[])propertyValue);
            }
            if (type == Short.TYPE) {
                return Arrays.toString((short[])propertyValue);
            }
            if (type == Character.TYPE) {
                return Arrays.toString((char[])propertyValue);
            }
            if (type == Integer.TYPE) {
                return Arrays.toString((int[])propertyValue);
            }
            if (type == Long.TYPE) {
                return Arrays.toString((long[])propertyValue);
            }
            if (type == Float.TYPE) {
                return Arrays.toString((float[])propertyValue);
            }
            if (type == Double.TYPE) {
                return Arrays.toString((double[])propertyValue);
            }
            return Arrays.toString((Object[])propertyValue);
        }
        return String.valueOf(propertyValue);
    }

    public RuntimeException notAllowed(NewIndexDescriptor descriptor) {
        return new IllegalStateException(String.format("Index for (%s) should not require unique values.", descriptor.userDescription(SchemaUtil.idTokenNameLookup)), this);
    }

    public abstract Object getPropertyValue();

    public abstract String evidenceMessage(String var1, String var2);
}

