/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.unsafe.impl.batchimport.RecordIdIterator;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.IoProducerStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class ReadRecordsStep<RECORD extends AbstractBaseRecord>
extends IoProducerStep {
    protected final RecordStore<RECORD> store;
    protected final RECORD record;
    protected final RecordCursor<RECORD> cursor;
    protected final long highId;
    private final RecordIdIterator ids;
    private final Class<RECORD> klass;
    private final int recordSize;
    private volatile long count;

    public ReadRecordsStep(StageControl control, Configuration config, RecordStore<RECORD> store, RecordIdIterator ids) {
        super(control, config);
        this.store = store;
        this.ids = ids;
        this.klass = store.newRecord().getClass();
        this.recordSize = store.getRecordSize();
        this.record = store.newRecord();
        this.cursor = store.newRecordCursor(this.record);
        this.highId = store.getHighId();
    }

    @Override
    public void start(int orderingGuarantees) {
        this.cursor.acquire(0L, RecordLoad.CHECK);
        super.start(orderingGuarantees);
    }

    @Override
    protected Object nextBatchOrNull(long ticket, int batchSize) {
        PrimitiveLongIterator ids;
        while ((ids = this.ids.nextBatch()) != null) {
            AbstractBaseRecord[] batch = (AbstractBaseRecord[])Array.newInstance(this.klass, batchSize);
            int i = 0;
            while (ids.hasNext()) {
                if (!this.cursor.next(ids.next()) || IdValidator.isReservedId(((AbstractBaseRecord)this.record).getId())) continue;
                batch[i++] = ((AbstractBaseRecord)this.record).clone();
            }
            if (i <= 0) continue;
            this.count += (long)i;
            return i == batchSize ? batch : Arrays.copyOf(batch, i);
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.cursor.close();
    }

    @Override
    protected long position() {
        return this.count * (long)this.recordSize;
    }
}

