/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.schema;

import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.SchemaComputer;
import org.neo4j.kernel.api.schema_new.SchemaDescriptor;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;

public interface SchemaRule
extends SchemaDescriptor.Supplier {
    public long getId();

    public static enum Kind {
        INDEX_RULE("Index"),
        CONSTRAINT_INDEX_RULE("Constraint index"),
        UNIQUENESS_CONSTRAINT("Uniqueness constraint"),
        NODE_PROPERTY_EXISTENCE_CONSTRAINT("Node property existence constraint"),
        RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT("Relationship property existence constraint");

        private static final Kind[] ALL;
        private final String userString;
        private static SchemaComputer<Kind> existenceKindMapper;

        private Kind(String userString) {
            this.userString = userString;
        }

        public byte id() {
            return (byte)(this.ordinal() + 1);
        }

        public String userString() {
            return this.userString;
        }

        public static Kind forId(byte id) throws MalformedSchemaRuleException {
            if (id >= 1 && id <= ALL.length) {
                return Kind.values()[id - 1];
            }
            throw new MalformedSchemaRuleException(null, "Unknown kind id %d", new Object[]{id});
        }

        public static Kind map(NewIndexDescriptor descriptor) {
            switch (descriptor.type()) {
                case GENERAL: {
                    return INDEX_RULE;
                }
                case UNIQUE: {
                    return CONSTRAINT_INDEX_RULE;
                }
            }
            throw new IllegalStateException("Cannot end up here, says johant");
        }

        public static Kind map(ConstraintDescriptor descriptor) {
            switch (descriptor.type()) {
                case UNIQUE: {
                    return UNIQUENESS_CONSTRAINT;
                }
                case EXISTS: {
                    return existenceKindMapper.compute(descriptor.schema());
                }
            }
            throw new IllegalStateException("Cannot end up here, says johant");
        }

        static {
            ALL = Kind.values();
            existenceKindMapper = new SchemaComputer<Kind>(){

                @Override
                public Kind computeSpecific(LabelSchemaDescriptor schema) {
                    return NODE_PROPERTY_EXISTENCE_CONSTRAINT;
                }

                @Override
                public Kind computeSpecific(RelationTypeSchemaDescriptor schema) {
                    return RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT;
                }
            };
        }
    }
}

