/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.Collection;
import java.util.function.IntPredicate;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.NodePropertyUpdates;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.transaction.state.storeview.StoreViewNodeStoreScan;
import org.neo4j.register.Register;
import org.neo4j.storageengine.api.EntityType;

public class NeoStoreIndexStoreView
implements IndexStoreView {
    protected final PropertyStore propertyStore;
    protected final NodeStore nodeStore;
    protected final LockService locks;
    private final CountsTracker counts;

    public NeoStoreIndexStoreView(LockService locks, NeoStores neoStores) {
        this.locks = locks;
        this.propertyStore = neoStores.getPropertyStore();
        this.nodeStore = neoStores.getNodeStore();
        this.counts = neoStores.getCounts();
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(long indexId, Register.DoubleLongRegister output) {
        return this.counts.indexUpdatesAndSize(indexId, output);
    }

    @Override
    public void replaceIndexCounts(long indexId, long uniqueElements, long maxUniqueElements, long indexSize) {
        try (CountsAccessor.IndexStatsUpdater updater = this.counts.updateIndexCounts();){
            updater.replaceIndexSample(indexId, uniqueElements, maxUniqueElements);
            updater.replaceIndexUpdateAndSize(indexId, 0L, indexSize);
        }
    }

    @Override
    public void incrementIndexUpdates(long indexId, long updatesDelta) {
        try (CountsAccessor.IndexStatsUpdater updater = this.counts.updateIndexCounts();){
            updater.incrementIndexUpdates(indexId, updatesDelta);
        }
    }

    @Override
    public Register.DoubleLongRegister indexSample(long indexId, Register.DoubleLongRegister output) {
        return this.counts.indexSample(indexId, output);
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, Visitor<NodePropertyUpdates, FAILURE> propertyUpdatesVisitor, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor) {
        return new StoreViewNodeStoreScan<FAILURE>(this.nodeStore, this.locks, this.propertyStore, labelUpdateVisitor, propertyUpdatesVisitor, labelIds, propertyKeyIdFilter);
    }

    @Override
    public void nodeAsUpdates(long nodeId, Collection<NodePropertyUpdate> target) {
        NodeRecord node = (NodeRecord)this.nodeStore.getRecord(nodeId, this.nodeStore.newRecord(), RecordLoad.FORCE);
        if (!node.inUse()) {
            return;
        }
        long firstPropertyId = node.getNextProp();
        if (firstPropertyId == (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return;
        }
        long[] labels = NodeLabelsField.parseLabelsField(node).get(this.nodeStore);
        if (labels.length == 0) {
            return;
        }
        for (PropertyRecord propertyRecord : this.propertyStore.getPropertyRecordChain(firstPropertyId)) {
            for (PropertyBlock property : propertyRecord) {
                Object value = property.getType().getValue(property, this.propertyStore);
                target.add(NodePropertyUpdate.add(node.getId(), property.getKeyIndexId(), value, labels));
            }
        }
    }

    @Override
    public Property getProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        NodeRecord node = (NodeRecord)this.nodeStore.getRecord(nodeId, this.nodeStore.newRecord(), RecordLoad.FORCE);
        if (!node.inUse()) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId);
        }
        long firstPropertyId = node.getNextProp();
        if (firstPropertyId == (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return Property.noNodeProperty(nodeId, propertyKeyId);
        }
        for (PropertyRecord propertyRecord : this.propertyStore.getPropertyRecordChain(firstPropertyId)) {
            PropertyBlock propertyBlock = propertyRecord.getPropertyBlock(propertyKeyId);
            if (propertyBlock == null) continue;
            return propertyBlock.newPropertyData(this.propertyStore);
        }
        return Property.noNodeProperty(nodeId, propertyKeyId);
    }
}

