/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.index.NodePropertyUpdates;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelScanViewNodeStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.register.Registers;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;

public class DynamicIndexStoreView
extends NeoStoreIndexStoreView {
    private static final int VISIT_ALL_NODES_THRESHOLD_PERCENTAGE = FeatureToggles.getInteger(DynamicIndexStoreView.class, (String)"all.nodes.visit.percentage.threshold", (int)10);
    protected static boolean USE_LABEL_INDEX_FOR_SCHEMA_INDEX_POPULATION = FeatureToggles.flag(DynamicIndexStoreView.class, (String)"use.label.index", (boolean)true);
    private final LabelScanStore labelScanStore;
    private final CountsTracker counts;
    private final Log log;

    public DynamicIndexStoreView(LabelScanStore labelScanStore, LockService locks, NeoStores neoStores, LogProvider logProvider) {
        super(locks, neoStores);
        this.counts = neoStores.getCounts();
        this.labelScanStore = labelScanStore;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, Visitor<NodePropertyUpdates, FAILURE> propertyUpdatesVisitor, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor) {
        if (!USE_LABEL_INDEX_FOR_SCHEMA_INDEX_POPULATION || this.useAllNodeStoreScan(labelIds)) {
            return super.visitNodes(labelIds, propertyKeyIdFilter, propertyUpdatesVisitor, labelUpdateVisitor);
        }
        return new LabelScanViewNodeStoreScan<FAILURE>(this.nodeStore, this.locks, this.propertyStore, this.labelScanStore, labelUpdateVisitor, propertyUpdatesVisitor, labelIds, propertyKeyIdFilter);
    }

    private boolean useAllNodeStoreScan(int[] labelIds) {
        try {
            return ArrayUtils.isEmpty((int[])labelIds) || this.isEmptyLabelScanStore() || this.isNumberOfLabeledNodesExceedThreshold(labelIds);
        }
        catch (Exception e) {
            this.log.error("Can not determine number of labeled nodes, falling back to all nodes scan.", (Throwable)e);
            return true;
        }
    }

    private boolean isEmptyLabelScanStore() throws Exception {
        return this.labelScanStore.isEmpty();
    }

    private boolean isNumberOfLabeledNodesExceedThreshold(int[] labelIds) {
        return this.getNumberOfLabeledNodes(labelIds) > this.getVisitAllNodesThreshold();
    }

    private long getVisitAllNodesThreshold() {
        return (long)((float)VISIT_ALL_NODES_THRESHOLD_PERCENTAGE / 100.0f * (float)this.nodeStore.getHighestPossibleIdInUse());
    }

    private long getNumberOfLabeledNodes(int[] labelIds) {
        return IntStream.of(labelIds).mapToLong(labelId -> this.counts.nodeCount(labelId, Registers.newDoubleLongRegister()).readSecond()).reduce(Math::addExact).orElse(0L);
    }
}

