/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.SchemaComputer;
import org.neo4j.kernel.api.schema_new.SchemaProcessor;
import org.neo4j.kernel.api.schema_new.SchemaUtil;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptorFactory;
import org.neo4j.kernel.impl.store.record.AbstractSchemaRule;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.string.UTF8;

public class IndexRule
extends AbstractSchemaRule {
    private static final long NO_OWNING_CONSTRAINT = -1L;
    private final SchemaIndexProvider.Descriptor providerDescriptor;
    private final NewIndexDescriptor descriptor;
    private final long owningConstraint;
    private SchemaComputer<Integer> lengthComputer = new SchemaComputer<Integer>(){

        @Override
        public Integer computeSpecific(LabelSchemaDescriptor schema) {
            return 5 + UTF8.computeRequiredByteBufferSize((String)IndexRule.this.providerDescriptor.getKey()) + UTF8.computeRequiredByteBufferSize((String)IndexRule.this.providerDescriptor.getVersion()) + 2 + 8 + (IndexRule.this.canSupportUniqueConstraint() ? 8 : 0);
        }

        @Override
        public Integer computeSpecific(RelationTypeSchemaDescriptor schema) {
            throw new UnsupportedOperationException("This constraint type is not yet supported by the store");
        }
    };

    static IndexRule readIndexRule(long id, boolean constraintIndex, int label, ByteBuffer serialized) {
        SchemaIndexProvider.Descriptor providerDescriptor = IndexRule.readProviderDescriptor(serialized);
        int[] propertyKeyIds = IndexRule.readPropertyKeys(serialized);
        NewIndexDescriptor descriptor = constraintIndex ? NewIndexDescriptorFactory.uniqueForLabel(label, propertyKeyIds) : NewIndexDescriptorFactory.forLabel(label, propertyKeyIds);
        long owningConstraint = constraintIndex ? IndexRule.readOwningConstraint(serialized) : -1L;
        return new IndexRule(id, providerDescriptor, descriptor, owningConstraint);
    }

    public static IndexRule indexRule(long id, NewIndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor) {
        return new IndexRule(id, providerDescriptor, descriptor, -1L);
    }

    public static IndexRule constraintIndexRule(long id, NewIndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, long owningConstraint) {
        return new IndexRule(id, providerDescriptor, descriptor, owningConstraint);
    }

    private static SchemaIndexProvider.Descriptor readProviderDescriptor(ByteBuffer serialized) {
        String providerKey = UTF8.getDecodedStringFrom((ByteBuffer)serialized);
        String providerVersion = UTF8.getDecodedStringFrom((ByteBuffer)serialized);
        return new SchemaIndexProvider.Descriptor(providerKey, providerVersion);
    }

    private static int[] readPropertyKeys(ByteBuffer serialized) {
        int count = serialized.getShort();
        assert (count >= 1);
        int[] props = new int[count];
        for (int i = 0; i < count; ++i) {
            props[i] = IoPrimitiveUtils.safeCastLongToInt(serialized.getLong());
        }
        return props;
    }

    private static long readOwningConstraint(ByteBuffer serialized) {
        return serialized.getLong();
    }

    private IndexRule(long id, SchemaIndexProvider.Descriptor providerDescriptor, NewIndexDescriptor descriptor, long owningConstraint) {
        super(id);
        if (providerDescriptor == null) {
            throw new IllegalArgumentException("null provider descriptor prohibited");
        }
        this.descriptor = descriptor;
        this.owningConstraint = owningConstraint;
        this.providerDescriptor = providerDescriptor;
    }

    public SchemaIndexProvider.Descriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    public boolean canSupportUniqueConstraint() {
        return this.descriptor.type() == NewIndexDescriptor.Type.UNIQUE;
    }

    public Long getOwningConstraint() {
        if (!this.canSupportUniqueConstraint()) {
            throw new IllegalStateException("Can only get owner from constraint indexes.");
        }
        long owningConstraint = this.owningConstraint;
        if (owningConstraint == -1L) {
            return null;
        }
        return owningConstraint;
    }

    public IndexRule withOwningConstraint(long constraintId) {
        if (!this.canSupportUniqueConstraint()) {
            throw new IllegalStateException(this + " is not a constraint index");
        }
        return IndexRule.constraintIndexRule(this.id, this.descriptor, this.providerDescriptor, constraintId);
    }

    @Override
    public int length() {
        return this.lengthComputer.computeSpecific(this.descriptor.schema());
    }

    @Override
    public void serialize(ByteBuffer target) {
        new Serializer(target).processSpecific(this.descriptor.schema());
    }

    public String toString() {
        String ownerString = "";
        if (this.canSupportUniqueConstraint()) {
            ownerString = ", owner=" + this.owningConstraint;
        }
        return "IndexRule[id=" + this.id + ", descriptor=" + this.descriptor.userDescription(SchemaUtil.noopTokenNameLookup) + ", provider=" + this.providerDescriptor + ownerString + "]";
    }

    @Override
    public LabelSchemaDescriptor getSchemaDescriptor() {
        return this.descriptor.schema();
    }

    public NewIndexDescriptor getIndexDescriptor() {
        return this.descriptor;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof IndexRule) {
            IndexRule that = (IndexRule)o;
            return this.descriptor.equals(that.descriptor);
        }
        return false;
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    class Serializer
    implements SchemaProcessor {
        private final ByteBuffer buffer;

        Serializer(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void processSpecific(LabelSchemaDescriptor schema) {
            this.buffer.putInt(schema.getLabelId());
            SchemaRule.Kind kind = IndexRule.this.canSupportUniqueConstraint() ? SchemaRule.Kind.CONSTRAINT_INDEX_RULE : SchemaRule.Kind.INDEX_RULE;
            this.buffer.put(kind.id());
            UTF8.putEncodedStringInto((String)IndexRule.this.providerDescriptor.getKey(), (ByteBuffer)this.buffer);
            UTF8.putEncodedStringInto((String)IndexRule.this.providerDescriptor.getVersion(), (ByteBuffer)this.buffer);
            this.buffer.putShort((short)1);
            this.buffer.putLong(schema.getPropertyIds()[0]);
            if (IndexRule.this.canSupportUniqueConstraint()) {
                this.buffer.putLong(IndexRule.this.owningConstraint);
            }
        }

        @Override
        public void processSpecific(RelationTypeSchemaDescriptor schema) {
            throw new UnsupportedOperationException("This index type is not yet supported by the store");
        }
    }
}

