/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema_new.constaints;

import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.schema.IndexDescriptorFactory;
import org.neo4j.kernel.api.schema.RelationshipPropertyDescriptor;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.SchemaComputer;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptor;

public class ConstraintBoundary {
    public static PropertyConstraint map(ConstraintDescriptor descriptor) {
        return (PropertyConstraint)new BoundaryTransformer(descriptor).compute(descriptor.schema());
    }

    public static NodePropertyConstraint mapNode(ConstraintDescriptor descriptor) {
        return (NodePropertyConstraint)new BoundaryTransformer(descriptor).compute(descriptor.schema());
    }

    public static RelationshipPropertyConstraint mapRelationship(ConstraintDescriptor descriptor) {
        return (RelationshipPropertyConstraint)new BoundaryTransformer(descriptor).compute(descriptor.schema());
    }

    static class BoundaryTransformer
    implements SchemaComputer<PropertyConstraint> {
        private final ConstraintDescriptor descriptor;

        BoundaryTransformer(ConstraintDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public PropertyConstraint computeSpecific(LabelSchemaDescriptor schema) {
            switch (this.descriptor.type()) {
                case UNIQUE: {
                    return new UniquenessConstraint(IndexDescriptorFactory.getNodePropertyDescriptor(schema.getLabelId(), schema.getPropertyIds()[0]));
                }
                case EXISTS: {
                    return new NodePropertyExistenceConstraint(IndexDescriptorFactory.getNodePropertyDescriptor(schema.getLabelId(), schema.getPropertyIds()[0]));
                }
            }
            throw new UnsupportedOperationException("Although we cannot get here, this has not been implemented.");
        }

        @Override
        public PropertyConstraint computeSpecific(RelationTypeSchemaDescriptor schema) {
            return new RelationshipPropertyExistenceConstraint(new RelationshipPropertyDescriptor(schema.getRelTypeId(), schema.getPropertyIds()[0]));
        }
    }
}

