/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema_new;

import org.neo4j.kernel.api.TokenNameLookup;

public class SchemaUtil {
    public static TokenNameLookup noopTokenNameLookup = new PrefixTokenName("");

    private SchemaUtil() {
    }

    public static String niceProperties(TokenNameLookup tokenNameLookup, int[] propertyIds) {
        CharSequence[] properties = new String[propertyIds.length];
        for (int i = 0; i < propertyIds.length; ++i) {
            properties[i] = tokenNameLookup.propertyKeyGetName(propertyIds[i]);
        }
        return String.join((CharSequence)", ", properties);
    }

    public static class PrefixTokenName
    implements TokenNameLookup {
        private final String prefix;

        public PrefixTokenName(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public String labelGetName(int labelId) {
            return this.prefix + labelId;
        }

        @Override
        public String relationshipTypeGetName(int relationshipTypeId) {
            return this.prefix + relationshipTypeId;
        }

        @Override
        public String propertyKeyGetName(int propertyKeyId) {
            return this.prefix + propertyKeyId;
        }
    }
}

