/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema_new;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.SchemaComputer;
import org.neo4j.kernel.api.schema_new.SchemaDescriptor;

public class SchemaDescriptorPredicates {
    private static SchemaComputer<Optional<Integer>> getLabel = new SchemaComputer<Optional<Integer>>(){

        @Override
        public Optional<Integer> computeSpecific(LabelSchemaDescriptor schema) {
            return Optional.of(schema.getLabelId());
        }

        @Override
        public Optional<Integer> computeSpecific(RelationTypeSchemaDescriptor schema) {
            return Optional.empty();
        }
    };
    private static SchemaComputer<Optional<Integer>> getRelType = new SchemaComputer<Optional<Integer>>(){

        @Override
        public Optional<Integer> computeSpecific(LabelSchemaDescriptor schema) {
            return Optional.empty();
        }

        @Override
        public Optional<Integer> computeSpecific(RelationTypeSchemaDescriptor schema) {
            return Optional.of(schema.getRelTypeId());
        }
    };
    private static SchemaComputer<List<Integer>> getProperties = new SchemaComputer<List<Integer>>(){

        @Override
        public List<Integer> computeSpecific(LabelSchemaDescriptor schema) {
            return SchemaDescriptorPredicates.asList(schema.getPropertyIds());
        }

        @Override
        public List<Integer> computeSpecific(RelationTypeSchemaDescriptor schema) {
            return SchemaDescriptorPredicates.asList(schema.getPropertyIds());
        }
    };

    public static boolean hasLabel(SchemaDescriptor.Supplier supplier, int labelId) {
        Optional<Integer> labelOpt = getLabel.compute(supplier.getSchemaDescriptor());
        return labelOpt.isPresent() && labelOpt.get() == labelId;
    }

    public static boolean hasRelType(SchemaDescriptor.Supplier supplier, int relTypeId) {
        Optional<Integer> relTypeOpt = getRelType.compute(supplier.getSchemaDescriptor());
        return relTypeOpt.isPresent() && relTypeOpt.get() == relTypeId;
    }

    public static boolean hasProperty(SchemaDescriptor.Supplier supplier, int propertyId) {
        List<Integer> properties = getProperties.compute(supplier.getSchemaDescriptor());
        return properties.contains(propertyId);
    }

    private static List<Integer> asList(int[] ints) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i : ints) {
            list.add(i);
        }
        return list;
    }
}

