/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.schema.EntityPropertyDescriptor;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;

public class NodeMultiPropertyDescriptor
extends NodePropertyDescriptor {
    private final int[] propertyKeyIds;

    public NodeMultiPropertyDescriptor(int labelId, int[] propertyKeyIds) {
        super(labelId, -1);
        this.propertyKeyIds = propertyKeyIds;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof NodeMultiPropertyDescriptor) {
            NodeMultiPropertyDescriptor that = (NodeMultiPropertyDescriptor)obj;
            return this.getLabelId() == that.getLabelId() && Arrays.equals(this.propertyKeyIds, that.propertyKeyIds);
        }
        return false;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public int hashCode() {
        int result = this.getLabelId();
        for (int element : this.propertyKeyIds) {
            result = 31 * result + element;
        }
        return result;
    }

    @Override
    public int getPropertyKeyId() {
        throw new UnsupportedOperationException("Cannot get single property Id of composite index");
    }

    @Override
    public int[] getPropertyKeyIds() {
        return this.propertyKeyIds;
    }

    @Override
    public String propertyIdText() {
        return Arrays.stream(this.propertyKeyIds).mapToObj(Integer::toString).collect(Collectors.joining(","));
    }

    @Override
    public String propertyNameText(TokenNameLookup tokenNameLookup) {
        return Arrays.stream(this.propertyKeyIds).mapToObj(tokenNameLookup::propertyKeyGetName).collect(Collectors.joining(","));
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        return String.format(":%s(%s)", tokenNameLookup.labelGetName(this.getLabelId()), this.propertyNameText(tokenNameLookup));
    }

    @Override
    public int compareTo(EntityPropertyDescriptor other) {
        if (other instanceof NodeMultiPropertyDescriptor) {
            NodeMultiPropertyDescriptor that = (NodeMultiPropertyDescriptor)other;
            int cmp = this.entityId - that.entityId;
            if (cmp == 0 && !Arrays.equals(this.propertyKeyIds, that.propertyKeyIds) && (cmp = this.propertyKeyIds.length - that.propertyKeyIds.length) == 0) {
                for (int i = 0; i < this.propertyKeyIds.length; ++i) {
                    cmp = this.propertyKeyIds[i] - that.propertyKeyIds[i];
                    if (cmp == 0) continue;
                    return cmp;
                }
            }
            return cmp;
        }
        return -1;
    }
}

