/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.HashMap;
import java.util.Map;

public abstract class IndexUsage {
    final String identifier;

    public static IndexUsage schemaIndexUsage(String identifier, String label, String propertyKey) {
        return new SchemaIndexUsage(identifier, label, propertyKey);
    }

    public static IndexUsage legacyIndexUsage(String identifier, String entityType, String index) {
        return new LegacyIndexUsage(identifier, index, entityType);
    }

    abstract Map<String, String> asMap();

    private IndexUsage(String identifier) {
        this.identifier = identifier;
    }

    private static class LegacyIndexUsage
    extends IndexUsage {
        private final String index;
        private final String entityType;

        private LegacyIndexUsage(String identifier, String index, String entityType) {
            super(identifier);
            this.index = index;
            this.entityType = entityType;
        }

        @Override
        Map<String, String> asMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("indexType", "LEGACY INDEX");
            map.put("entityType", this.entityType);
            map.put("identifier", this.identifier);
            map.put("indexName", this.index);
            return map;
        }
    }

    private static class SchemaIndexUsage
    extends IndexUsage {
        private final String label;
        private final String propertyKey;

        private SchemaIndexUsage(String identifier, String label, String propertyKey) {
            super(identifier);
            this.label = label;
            this.propertyKey = propertyKey;
        }

        @Override
        Map<String, String> asMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("indexType", "SCHEMA INDEX");
            map.put("entityType", "NODE");
            map.put("identifier", this.identifier);
            map.put("label", this.label);
            map.put("propertyKey", this.propertyKey);
            return map;
        }
    }
}

