/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.properties.PropertyKeyIdIterator;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.store.AllRecordIdIterator;
import org.neo4j.kernel.impl.api.store.AllRelationshipIterator;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.core.IteratingPropertyReceiver;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodePropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.schema.IndexSchemaRule;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class DiskLayer
implements StoreReadLayer {
    private static final Function<PropertyConstraintRule, PropertyConstraint> RULE_TO_CONSTRAINT = PropertyConstraintRule::toConstraint;
    private static final Function<NodePropertyConstraintRule, NodePropertyConstraint> NODE_RULE_TO_CONSTRAINT = NodePropertyConstraintRule::toConstraint;
    private static final Function<RelationshipPropertyConstraintRule, RelationshipPropertyConstraint> REL_RULE_TO_CONSTRAINT = RelationshipPropertyConstraintRule::toConstraint;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final RelationshipTypeTokenHolder relationshipTokenHolder;
    private final NeoStores neoStores;
    private final IndexingService indexService;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final SchemaStorage schemaStorage;
    private final CountsTracker counts;
    private final PropertyLoader propertyLoader;
    private final Supplier<StorageStatement> statementProvider;
    private static final Predicate<SchemaRule> INDEX_RULES = rule -> rule.getKind() == SchemaRule.Kind.INDEX_RULE;
    private static final Predicate<SchemaRule> CONSTRAINT_INDEX_RULES = rule -> rule.getKind() == SchemaRule.Kind.CONSTRAINT_INDEX_RULE;

    public DiskLayer(PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, RelationshipTypeTokenHolder relationshipTokenHolder, SchemaStorage schemaStorage, NeoStores neoStores, IndexingService indexService, Supplier<StorageStatement> storeStatementSupplier) {
        this.relationshipTokenHolder = relationshipTokenHolder;
        this.schemaStorage = schemaStorage;
        this.indexService = indexService;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
        this.neoStores = neoStores;
        this.statementProvider = storeStatementSupplier;
        this.nodeStore = this.neoStores.getNodeStore();
        this.relationshipStore = this.neoStores.getRelationshipStore();
        this.counts = neoStores.getCounts();
        this.propertyLoader = new PropertyLoader(neoStores);
    }

    @Override
    public StorageStatement newStatement() {
        return this.statementProvider.get();
    }

    @Override
    public int labelGetOrCreateForName(String label) throws TooManyLabelsException {
        try {
            return this.labelTokenHolder.getOrCreateId(label);
        }
        catch (TransactionFailureException e) {
            if (e.getCause() instanceof UnderlyingStorageException && e.getCause().getMessage().equals("Id capacity exceeded")) {
                throw new TooManyLabelsException(e);
            }
            throw e;
        }
    }

    @Override
    public int labelGetForName(String label) {
        return this.labelTokenHolder.getIdByName(label);
    }

    @Override
    public String labelGetName(int labelId) throws LabelNotFoundKernelException {
        try {
            return ((Token)this.labelTokenHolder.getTokenById(labelId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new LabelNotFoundKernelException("Label by id " + labelId, e);
        }
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(StorageStatement statement, int labelId) {
        return statement.getLabelScanReader().nodesWithLabel(labelId);
    }

    @Override
    public IndexDescriptor indexGetForLabelAndPropertyKey(int labelId, int propertyKey) {
        return DiskLayer.descriptor(this.schemaStorage.indexRule(labelId, propertyKey));
    }

    private static IndexDescriptor descriptor(IndexRule ruleRecord) {
        return new IndexDescriptor(ruleRecord.getLabel(), ruleRecord.getPropertyKey());
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        return this.getIndexDescriptorsFor(DiskLayer.indexRules(labelId));
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll() {
        return this.getIndexDescriptorsFor(INDEX_RULES);
    }

    @Override
    public Iterator<IndexDescriptor> uniquenessIndexesGetForLabel(int labelId) {
        return this.getIndexDescriptorsFor(DiskLayer.constraintIndexRules(labelId));
    }

    @Override
    public Iterator<IndexDescriptor> uniquenessIndexesGetAll() {
        return this.getIndexDescriptorsFor(CONSTRAINT_INDEX_RULES);
    }

    private static Predicate<SchemaRule> indexRules(int labelId) {
        return rule -> rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.INDEX_RULE;
    }

    private static Predicate<SchemaRule> constraintIndexRules(int labelId) {
        return rule -> rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
    }

    private Iterator<IndexDescriptor> getIndexDescriptorsFor(Predicate<SchemaRule> filter) {
        Iterator filtered = Iterators.filter(filter, this.neoStores.getSchemaStore().loadAllSchemaRules());
        return Iterators.map(from -> DiskLayer.descriptor((IndexRule)from), (Iterator)filtered);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId()).getOwningConstraint();
    }

    @Override
    public IndexSchemaRule indexRule(IndexDescriptor index, Predicate<SchemaRule.Kind> filter) {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId());
    }

    @Override
    public long indexGetCommittedId(IndexDescriptor index, Predicate<SchemaRule.Kind> filter) throws SchemaRuleNotFoundException {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId()).getId();
    }

    @Override
    public InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(descriptor).getState();
    }

    @Override
    public PopulationProgress indexGetPopulationProgress(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(descriptor).getIndexPopulationProgress();
    }

    @Override
    public long indexSize(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        Register.DoubleLongRegister result = this.indexService.indexUpdatesAndSize(descriptor);
        return result.readSecond();
    }

    @Override
    public double indexUniqueValuesPercentage(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.indexUniqueValuesPercentage(descriptor);
    }

    @Override
    public String indexGetFailure(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(descriptor).getPopulationFailure().asString();
    }

    @Override
    public Iterator<NodePropertyConstraint> constraintsGetForLabelAndPropertyKey(int labelId, int propertyKeyId) {
        return this.schemaStorage.schemaRulesForNodes(NODE_RULE_TO_CONSTRAINT, NodePropertyConstraintRule.class, labelId, rule -> rule.containsPropertyKeyId(propertyKeyId));
    }

    @Override
    public Iterator<NodePropertyConstraint> constraintsGetForLabel(int labelId) {
        return this.schemaStorage.schemaRulesForNodes(NODE_RULE_TO_CONSTRAINT, NodePropertyConstraintRule.class, labelId, Predicates.alwaysTrue());
    }

    @Override
    public Iterator<RelationshipPropertyConstraint> constraintsGetForRelationshipTypeAndPropertyKey(int typeId, int propertyKeyId) {
        return this.schemaStorage.schemaRulesForRelationships(REL_RULE_TO_CONSTRAINT, RelationshipPropertyConstraintRule.class, typeId, rule -> rule.containsPropertyKeyId(propertyKeyId));
    }

    @Override
    public Iterator<RelationshipPropertyConstraint> constraintsGetForRelationshipType(int typeId) {
        return this.schemaStorage.schemaRulesForRelationships(REL_RULE_TO_CONSTRAINT, RelationshipPropertyConstraintRule.class, typeId, Predicates.alwaysTrue());
    }

    @Override
    public Iterator<PropertyConstraint> constraintsGetAll() {
        return this.schemaStorage.schemaRules(RULE_TO_CONSTRAINT, PropertyConstraintRule.class);
    }

    @Override
    public int propertyKeyGetOrCreateForName(String propertyKey) {
        return this.propertyKeyTokenHolder.getOrCreateId(propertyKey);
    }

    @Override
    public int propertyKeyGetForName(String propertyKey) {
        return this.propertyKeyTokenHolder.getIdByName(propertyKey);
    }

    @Override
    public String propertyKeyGetName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        try {
            return ((Token)this.propertyKeyTokenHolder.getTokenById(propertyKeyId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new PropertyKeyIdNotFoundKernelException(propertyKeyId, e);
        }
    }

    @Override
    public PrimitiveIntIterator graphGetPropertyKeys() {
        return new PropertyKeyIdIterator((Iterator)((Object)this.propertyLoader.graphLoadProperties(new IteratingPropertyReceiver())));
    }

    @Override
    public Object graphGetProperty(int propertyKeyId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<StorageProperty> graphGetAllProperties() {
        return (Iterator)((Object)this.propertyLoader.graphLoadProperties(new IteratingPropertyReceiver()));
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens() {
        return this.propertyKeyTokenHolder.getAllTokens().iterator();
    }

    @Override
    public Iterator<Token> labelsGetAllTokens() {
        return this.labelTokenHolder.getAllTokens().iterator();
    }

    @Override
    public Iterator<Token> relationshipTypeGetAllTokens() {
        return this.relationshipTokenHolder.getAllTokens().iterator();
    }

    @Override
    public int relationshipTypeGetForName(String relationshipTypeName) {
        return this.relationshipTokenHolder.getIdByName(relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        try {
            return ((RelationshipTypeToken)this.relationshipTokenHolder.getTokenById(relationshipTypeId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new RelationshipTypeIdNotFoundKernelException(relationshipTypeId, e);
        }
    }

    @Override
    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) {
        return this.relationshipTokenHolder.getOrCreateId(relationshipTypeName);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> relationshipVisitor) throws EntityNotFoundException, EXCEPTION {
        RelationshipRecord record = (RelationshipRecord)this.relationshipStore.newRecord();
        if (!this.relationshipStore.getRecord(relationshipId, record, RecordLoad.FORCE).inUse()) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId);
        }
        relationshipVisitor.visit(relationshipId, record.getType(), record.getFirstNode(), record.getSecondNode());
    }

    @Override
    public PrimitiveLongIterator nodesGetAll() {
        return new AllRecordIdIterator<NodeRecord, NodeStore>(new NodeRecord(-1L), this.nodeStore);
    }

    @Override
    public RelationshipIterator relationshipsGetAll() {
        return new AllRelationshipIterator(new RelationshipRecord(-1L), this.relationshipStore);
    }

    @Override
    public long reserveNode() {
        return this.nodeStore.nextId();
    }

    @Override
    public long reserveRelationship() {
        return this.relationshipStore.nextId();
    }

    @Override
    public void releaseNode(long id) {
        this.nodeStore.freeId(id);
    }

    @Override
    public void releaseRelationship(long id) {
        this.relationshipStore.freeId(id);
    }

    @Override
    public long countsForNode(int labelId) {
        return this.counts.nodeCount(labelId, Registers.newDoubleLongRegister()).readSecond();
    }

    @Override
    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        if (startLabelId != -1 && endLabelId != -1) {
            throw new UnsupportedOperationException("not implemented");
        }
        return this.counts.relationshipCount(startLabelId, typeId, endLabelId, Registers.newDoubleLongRegister()).readSecond();
    }

    @Override
    public long nodesGetCount() {
        return this.nodeStore.getNumberOfIdsInUse();
    }

    @Override
    public long relationshipsGetCount() {
        return this.relationshipStore.getNumberOfIdsInUse();
    }

    @Override
    public int labelCount() {
        return this.labelTokenHolder.size();
    }

    @Override
    public int propertyKeyCount() {
        return this.propertyKeyTokenHolder.size();
    }

    @Override
    public int relationshipTypeCount() {
        return this.relationshipTokenHolder.size();
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(IndexDescriptor index, Register.DoubleLongRegister target) {
        return this.counts.indexUpdatesAndSize(index.getLabelId(), index.getPropertyKeyId(), target);
    }

    @Override
    public Register.DoubleLongRegister indexSample(IndexDescriptor index, Register.DoubleLongRegister target) {
        return this.counts.indexSample(index.getLabelId(), index.getPropertyKeyId(), target);
    }

    @Override
    public boolean nodeExists(long id) {
        return this.nodeStore.isInUse(id);
    }
}

