/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.neo4j.kernel.api.ExecutingQuery;

abstract class ExecutingQueryList {
    static ExecutingQueryList EMPTY = new ExecutingQueryList(){

        @Override
        public Stream<ExecutingQuery> queries() {
            return Stream.empty();
        }

        @Override
        public ExecutingQueryList push(ExecutingQuery newExecutingQuery) {
            return new Entry(newExecutingQuery, this);
        }

        @Override
        public ExecutingQueryList remove(ExecutingQuery executingQuery) {
            return this;
        }

        @Override
        <T> T reduce(T defaultValue, Function<ExecutingQuery, T> accessor, BiFunction<T, T, T> combinator) {
            return defaultValue;
        }
    };

    ExecutingQueryList() {
    }

    abstract Stream<ExecutingQuery> queries();

    abstract ExecutingQueryList push(ExecutingQuery var1);

    abstract ExecutingQueryList remove(ExecutingQuery var1);

    abstract <T> T reduce(T var1, Function<ExecutingQuery, T> var2, BiFunction<T, T, T> var3);

    private static class Entry
    extends ExecutingQueryList {
        final ExecutingQuery query;
        final ExecutingQueryList next;

        Entry(ExecutingQuery query, ExecutingQueryList next) {
            this.query = query;
            this.next = next;
        }

        @Override
        public Stream<ExecutingQuery> queries() {
            Stream.Builder<ExecutingQuery> builder = Stream.builder();
            ExecutingQueryList entry = this;
            while (entry != EMPTY) {
                Entry current = entry;
                builder.accept(current.query);
                entry = current.next;
            }
            return builder.build();
        }

        @Override
        public ExecutingQueryList push(ExecutingQuery newExecutingQuery) {
            assert (newExecutingQuery.internalQueryId() > this.query.internalQueryId());
            return new Entry(newExecutingQuery, this);
        }

        @Override
        public ExecutingQueryList remove(ExecutingQuery executingQuery) {
            if (executingQuery.equals(this.query)) {
                return this.next;
            }
            ExecutingQueryList removed = this.next.remove(executingQuery);
            if (removed == this.next) {
                return this;
            }
            return new Entry(this.query, removed);
        }

        @Override
        <T> T reduce(T defaultValue, Function<ExecutingQuery, T> accessor, BiFunction<T, T, T> combinator) {
            return this.next.reduce(combinator.apply(defaultValue, accessor.apply(this.query)), accessor, combinator);
        }
    }
}

