/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.time.SystemNanoClock;

abstract class ExecutingQueryStatus {
    private static final Map<String, Object> RUNNING_STATE = Collections.unmodifiableMap(Collections.singletonMap("state", "RUNNING"));
    static final ExecutingQueryStatus RUNNING = new ExecutingQueryStatus(){

        @Override
        long waitTimeNanos(SystemNanoClock clock) {
            return 0L;
        }

        @Override
        Map<String, Object> toMap(SystemNanoClock clock) {
            return RUNNING_STATE;
        }
    };

    ExecutingQueryStatus() {
    }

    abstract long waitTimeNanos(SystemNanoClock var1);

    abstract Map<String, Object> toMap(SystemNanoClock var1);

    static class WaitingOnLock
    extends ExecutingQueryStatus {
        private final ResourceType resourceType;
        private final long[] resourceIds;
        private final long startTimeNanos;

        WaitingOnLock(ResourceType resourceType, long[] resourceIds, long startTimeNanos) {
            this.resourceType = resourceType;
            this.resourceIds = resourceIds;
            this.startTimeNanos = startTimeNanos;
        }

        @Override
        long waitTimeNanos(SystemNanoClock clock) {
            return clock.nanos() - this.startTimeNanos;
        }

        @Override
        Map<String, Object> toMap(SystemNanoClock clock) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("state", "WAITING");
            map.put("waitTimeMillis", TimeUnit.NANOSECONDS.toMillis(this.waitTimeNanos(clock)));
            map.put("resourceType", this.resourceType.toString());
            map.put("resourceIds", this.resourceIds);
            return map;
        }
    }
}

