/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.cache.LongBitsManipulator;

public class NextFieldManipulator {
    private static final LongBitsManipulator MANIPULATOR = new LongBitsManipulator(48, 16);
    private static final long EMPTY_FIELD = MANIPULATOR.template(true, false);

    private NextFieldManipulator() {
    }

    public static long setNext(long field, long next) {
        return MANIPULATOR.set(field, 0, next);
    }

    public static long getNext(long field) {
        return MANIPULATOR.get(field, 0);
    }

    public static long setType(long field, int type) {
        return MANIPULATOR.set(field, 1, type);
    }

    public static int getType(long field) {
        return Utils.safeCastLongToInt(MANIPULATOR.get(field, 1));
    }

    public static long initialFieldWithType(int type) {
        return NextFieldManipulator.setType(EMPTY_FIELD, type);
    }
}

