/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.configuration.CommunityIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfiguration;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;

public class DefaultIdGeneratorFactory
implements IdGeneratorFactory {
    private final Map<IdType, IdGenerator> generators = new HashMap<IdType, IdGenerator>();
    private final FileSystemAbstraction fs;
    private final IdTypeConfigurationProvider idTypeConfigurationProvider;

    public DefaultIdGeneratorFactory(FileSystemAbstraction fs) {
        this(fs, new CommunityIdTypeConfigurationProvider());
    }

    public DefaultIdGeneratorFactory(FileSystemAbstraction fs, IdTypeConfigurationProvider idTypeConfigurationProvider) {
        this.fs = fs;
        this.idTypeConfigurationProvider = idTypeConfigurationProvider;
    }

    @Override
    public IdGenerator open(File filename, IdType idType, long highId, long maxId) {
        IdTypeConfiguration idTypeConfiguration = this.idTypeConfigurationProvider.getIdTypeConfiguration(idType);
        return this.open(filename, idTypeConfiguration.getGrabSize(), idType, highId, maxId);
    }

    @Override
    public IdGenerator open(File fileName, int grabSize, IdType idType, long highId, long maxId) {
        IdTypeConfiguration idTypeConfiguration = this.idTypeConfigurationProvider.getIdTypeConfiguration(idType);
        IdGenerator generator = this.instantiate(this.fs, fileName, grabSize, maxId, idTypeConfiguration.allowAggressiveReuse(), highId);
        this.generators.put(idType, generator);
        return generator;
    }

    protected IdGenerator instantiate(FileSystemAbstraction fs, File fileName, int grabSize, long maxValue, boolean aggressiveReuse, long highId) {
        return new IdGeneratorImpl(fs, fileName, grabSize, maxValue, aggressiveReuse, highId);
    }

    @Override
    public IdGenerator get(IdType idType) {
        return this.generators.get((Object)idType);
    }

    @Override
    public void create(File fileName, long highId, boolean throwIfFileExists) {
        IdGeneratorImpl.createGenerator(this.fs, fileName, highId, throwIfFileExists);
    }
}

