/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ParseUtil {
    private ParseUtil() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    static Map<String, Object> parseMap(String s) {
        int pos = 0;
        int braceCounter = 0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        StringBuilder builder = new StringBuilder();
        boolean inList = false;
        block8: while (pos < s.length()) {
            char character = s.charAt(pos);
            switch (character) {
                case ' ': {
                    ++pos;
                    continue block8;
                }
                case '{': {
                    if (braceCounter++ > 0) {
                        builder.append(s.charAt(pos));
                    }
                    ++pos;
                    continue block8;
                }
                case ',': {
                    if (!inList && braceCounter == 1) {
                        ParseUtil.addKeyValue(map, builder.toString().trim());
                        builder = new StringBuilder();
                    } else {
                        builder.append(s.charAt(pos));
                    }
                    ++pos;
                    continue block8;
                }
                case '}': {
                    if (--braceCounter == 0) {
                        ParseUtil.addKeyValue(map, builder.toString().trim());
                    } else {
                        builder.append(s.charAt(pos));
                    }
                    ++pos;
                    continue block8;
                }
                case '[': {
                    inList = true;
                    builder.append(s.charAt(pos++));
                    continue block8;
                }
                case ']': {
                    inList = false;
                    builder.append(s.charAt(pos++));
                    continue block8;
                }
            }
            builder.append(s.charAt(pos++));
        }
        if (braceCounter != 0) {
            throw new IllegalArgumentException(String.format("%s contains unbalanced '{', '}'.", s));
        }
        return map;
    }

    private static void addKeyValue(Map<String, Object> map, String keyValue) {
        if (keyValue.isEmpty()) {
            return;
        }
        int split = keyValue.indexOf(":");
        if (split < 0) {
            throw new IllegalArgumentException("Keys and values must be separated with ':'");
        }
        String key = ParseUtil.parseKey(keyValue.substring(0, split).trim());
        Object value = ParseUtil.parseValue(keyValue.substring(split + 1).trim(), Object.class);
        if (map.containsKey(key)) {
            throw new IllegalArgumentException(String.format("Multiple occurrences of key '%s'", key));
        }
        map.put(key, value);
    }

    private static String parseKey(String s) {
        block3: for (int pos = 0; pos < s.length(); ++pos) {
            char c = s.charAt(pos);
            switch (c) {
                case '\"': 
                case '\'': {
                    continue block3;
                }
            }
            return s.substring(pos, s.length() - pos);
        }
        throw new IllegalArgumentException("");
    }

    private static Object parseValue(String s, Type type) {
        block13: for (int pos = 0; pos < s.length(); ++pos) {
            char c = s.charAt(pos);
            switch (c) {
                case ' ': {
                    continue block13;
                }
                case '\'': {
                    int closing = s.lastIndexOf(39);
                    if (closing < 0) {
                        throw new IllegalArgumentException("Did not find a matching end quote, '");
                    }
                    return s.substring(pos + 1, closing);
                }
                case '\"': {
                    int closing = s.lastIndexOf(34);
                    if (closing < 0) {
                        throw new IllegalArgumentException("Did not find a matching end quote, \"");
                    }
                    return s.substring(pos + 1, closing);
                }
                case '{': {
                    return ParseUtil.parseMap(s.substring(pos));
                }
                case '[': {
                    if (type instanceof ParameterizedType) {
                        return ParseUtil.parseList(s.substring(pos), ((ParameterizedType)type).getActualTypeArguments()[0]);
                    }
                    return ParseUtil.parseList(s.substring(pos), Object.class);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    String number = s.substring(pos);
                    try {
                        return Long.parseLong(number);
                    }
                    catch (NumberFormatException e) {
                        return Double.parseDouble(number);
                    }
                }
                case 'n': {
                    if (s.charAt(pos + 1) == 'u' && s.charAt(pos + 2) == 'l' && s.charAt(pos + 3) == 'l') {
                        return null;
                    }
                }
                case 't': {
                    if (s.charAt(pos + 1) == 'r' && s.charAt(pos + 2) == 'u' && s.charAt(pos + 3) == 'e') {
                        return true;
                    }
                }
                case 'f': {
                    if (s.charAt(pos + 1) != 'a' || s.charAt(pos + 2) != 'l' || s.charAt(pos + 3) != 's' || s.charAt(pos + 4) != 'e') break;
                    return false;
                }
            }
            throw new IllegalArgumentException(String.format("%s is not a valid value", s));
        }
        throw new IllegalArgumentException(String.format("%s is not a valid value", s));
    }

    static <T> List<T> parseList(String s, Type type) {
        int pos = 0;
        int braceCounter = 0;
        ArrayList<Object> list = new ArrayList<Object>();
        StringBuilder builder = new StringBuilder();
        block6: while (pos < s.length()) {
            char character = s.charAt(pos);
            switch (character) {
                case ' ': {
                    ++pos;
                    continue block6;
                }
                case '[': {
                    if (braceCounter++ > 0) {
                        builder.append(s.charAt(pos));
                    }
                    ++pos;
                    continue block6;
                }
                case ',': {
                    if (braceCounter == 1) {
                        Object o = ParseUtil.parseValue(builder.toString().trim(), type);
                        ParseUtil.assertType(o, type);
                        list.add(o);
                        builder = new StringBuilder();
                    } else {
                        builder.append(s.charAt(pos));
                    }
                    ++pos;
                    continue block6;
                }
                case ']': {
                    if (--braceCounter == 0) {
                        String value = builder.toString().trim();
                        if (!value.isEmpty()) {
                            Object o = ParseUtil.parseValue(value, type);
                            ParseUtil.assertType(o, type);
                            list.add(o);
                        }
                    } else {
                        builder.append(s.charAt(pos));
                    }
                    ++pos;
                    continue block6;
                }
            }
            builder.append(s.charAt(pos++));
        }
        if (braceCounter != 0) {
            throw new IllegalArgumentException(String.format("%s contains unbalanced '[', ']'.", s));
        }
        return list;
    }

    private static void assertType(Object obj, Type type) {
        Class clazz;
        if (obj == null) {
            return;
        }
        if (type instanceof Class && !(clazz = (Class)type).isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException(String.format("Expects a list of %s but got a list of %s", clazz.getSimpleName(), obj.getClass().getSimpleName()));
        }
    }
}

