/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.impl.api.store.StoreAbstractRelationshipCursor;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;

public class StoreSingleRelationshipCursor
extends StoreAbstractRelationshipCursor {
    private final InstanceCache<StoreSingleRelationshipCursor> instanceCache;
    private long relationshipId = -1L;

    public StoreSingleRelationshipCursor(RelationshipRecord relationshipRecord, InstanceCache<StoreSingleRelationshipCursor> instanceCache, RecordCursors cursors, LockService lockService) {
        super(relationshipRecord, cursors, lockService);
        this.instanceCache = instanceCache;
    }

    public StoreSingleRelationshipCursor init(long relId, AssertOpen assertOpen) {
        this.initialize(assertOpen);
        this.relationshipId = relId;
        return this;
    }

    public boolean next() {
        if (this.relationshipId != -1L) {
            try {
                boolean bl = this.relationshipRecordCursor.next(this.relationshipId, this.relationshipRecord, RecordLoad.CHECK);
                return bl;
            }
            finally {
                this.relationshipId = -1L;
            }
        }
        return false;
    }

    public void close() {
        this.instanceCache.accept(this);
    }
}

