/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.schema.ConstraintViolationKernelException;

public class UniquePropertyConstraintViolationKernelException
extends ConstraintViolationKernelException {
    private final int labelId;
    private final int propertyKeyId;
    private final Object value;
    private final long existingNodeId;

    public UniquePropertyConstraintViolationKernelException(int labelId, int propertyKeyId, Object value, long existingNodeId) {
        super("Node %d already exists with label %d and property %d=%s", existingNodeId, labelId, propertyKeyId, value);
        this.labelId = labelId;
        this.propertyKeyId = propertyKeyId;
        this.value = value;
        this.existingNodeId = existingNodeId;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format("Node %d already exists with label %s and property \"%s\"=[%s]", this.existingNodeId, tokenNameLookup.labelGetName(this.labelId), tokenNameLookup.propertyKeyGetName(this.propertyKeyId), this.value);
    }

    public int labelId() {
        return this.labelId;
    }

    public int propertyKeyId() {
        return this.propertyKeyId;
    }

    public Object propertyValue() {
        return this.value;
    }
}

