/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapNumberArray;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public class OffHeapByteArray
extends OffHeapNumberArray<ByteArray>
implements ByteArray {
    private final byte[] defaultValue;

    protected OffHeapByteArray(long length, byte[] defaultValue, long base) {
        super(length, defaultValue.length, base);
        this.defaultValue = defaultValue;
        this.clear();
    }

    @Override
    public void swap(long fromIndex, long toIndex, int numberOfEntries) {
        int size = numberOfEntries * this.itemSize;
        long intermediary = UnsafeUtil.allocateMemory((long)size);
        UnsafeUtil.copyMemory((long)this.address(fromIndex, 0), (long)intermediary, (long)size);
        UnsafeUtil.copyMemory((long)this.address(toIndex, 0), (long)this.address(fromIndex, 0), (long)size);
        UnsafeUtil.copyMemory((long)intermediary, (long)this.address(toIndex, 0), (long)size);
        UnsafeUtil.free((long)intermediary);
    }

    @Override
    public void clear() {
        if (this.isByteUniform(this.defaultValue)) {
            UnsafeUtil.setMemory((long)this.address, (long)(this.length * (long)this.itemSize), (byte)this.defaultValue[0]);
        } else {
            long intermediary = UnsafeUtil.allocateMemory((long)this.itemSize);
            for (int i = 0; i < this.defaultValue.length; ++i) {
                UnsafeUtil.putByte((long)(intermediary + (long)i), (byte)this.defaultValue[i]);
            }
            long i = 0L;
            long adr = this.address;
            while (i < this.length) {
                UnsafeUtil.copyMemory((long)intermediary, (long)adr, (long)this.itemSize);
                ++i;
                adr += (long)this.itemSize;
            }
            UnsafeUtil.free((long)intermediary);
        }
    }

    private boolean isByteUniform(byte[] bytes) {
        byte reference = bytes[0];
        for (int i = 1; i < bytes.length; ++i) {
            if (reference == bytes[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void get(long index, byte[] into) {
        long address = this.address(index, 0);
        int i = 0;
        while (i < this.itemSize) {
            into[i] = UnsafeUtil.getByte((long)address);
            ++i;
            ++address;
        }
    }

    @Override
    public byte getByte(long index, int offset) {
        return UnsafeUtil.getByte((long)this.address(index, offset));
    }

    @Override
    public short getShort(long index, int offset) {
        return UnsafeUtil.getShort((long)this.address(index, offset));
    }

    @Override
    public int getInt(long index, int offset) {
        return UnsafeUtil.getInt((long)this.address(index, offset));
    }

    @Override
    public long get6ByteLong(long index, int offset) {
        long address = this.address(index, offset);
        long low4b = (long)UnsafeUtil.getInt((long)address) & 0xFFFFFFFFL;
        long high2b = UnsafeUtil.getShort((long)(address + 4L));
        return low4b | high2b << 32;
    }

    @Override
    public long getLong(long index, int offset) {
        return UnsafeUtil.getLong((long)this.address(index, offset));
    }

    @Override
    public void set(long index, byte[] value) {
        long address = this.address(index, 0);
        int i = 0;
        while (i < this.itemSize) {
            UnsafeUtil.putByte((long)address, (byte)value[i]);
            ++i;
            ++address;
        }
    }

    @Override
    public void setByte(long index, int offset, byte value) {
        UnsafeUtil.putByte((long)this.address(index, offset), (byte)value);
    }

    @Override
    public void setShort(long index, int offset, short value) {
        UnsafeUtil.putShort((long)this.address(index, offset), (short)value);
    }

    @Override
    public void setInt(long index, int offset, int value) {
        UnsafeUtil.putInt((long)this.address(index, offset), (int)value);
    }

    @Override
    public void set6ByteLong(long index, int offset, long value) {
        long address = this.address(index, offset);
        UnsafeUtil.putInt((long)address, (int)((int)value));
        UnsafeUtil.putShort((long)(address + 4L), (short)((short)(value >>> 32)));
    }

    @Override
    public void setLong(long index, int offset, long value) {
        UnsafeUtil.putLong((long)this.address(index, offset), (long)value);
    }

    @Override
    public int get3ByteInt(long index, int offset) {
        long address = this.address(index, offset);
        int lowWord = UnsafeUtil.getShort((long)address) & 0xFFFF;
        byte highByte = UnsafeUtil.getByte((long)(address + 2L));
        return lowWord | highByte << 16;
    }

    @Override
    public void set3ByteInt(long index, int offset, int value) {
        long address = this.address(index, offset);
        UnsafeUtil.putShort((long)address, (short)((short)value));
        UnsafeUtil.putByte((long)(address + 2L), (byte)((byte)(value >>> 16)));
    }

    private long address(long index, int offset) {
        return this.address + this.rebase(index) * (long)this.itemSize + (long)offset;
    }
}

