/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.countStore;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.countStore.CountsSnapshot;
import org.neo4j.kernel.impl.store.countStore.CountsStore;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.util.ArrayQueueOutOfOrderSequence;
import org.neo4j.kernel.impl.util.OutOfOrderSequence;

public class InMemoryCountsStore
implements CountsStore {
    private static final long[] EMPTY_METADATA = new long[]{1L};
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ConcurrentHashMap<CountsKey, long[]> map;
    private final OutOfOrderSequence lastTxId = new ArrayQueueOutOfOrderSequence(0L, 100, EMPTY_METADATA);
    private CountsSnapshot snapshot;

    public InMemoryCountsStore(CountsSnapshot snapshot) {
        this.map = new ConcurrentHashMap<CountsKey, long[]>(snapshot.getMap());
        this.lastTxId.set(snapshot.getTxId(), EMPTY_METADATA);
    }

    public InMemoryCountsStore() {
        this.map = new ConcurrentHashMap();
        this.lastTxId.set(0L, EMPTY_METADATA);
    }

    @Override
    public long[] get(CountsKey key) {
        return this.map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAll(long txId, Map<CountsKey, long[]> pairs) {
        this.lock.readLock().lock();
        try {
            this.applyUpdates(pairs, this.map);
            if (this.snapshot != null && this.snapshot.getTxId() >= txId) {
                this.applyUpdates(pairs, this.snapshot.getMap());
            }
            this.lastTxId.offer(txId, EMPTY_METADATA);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void applyUpdates(Map<CountsKey, long[]> updates, Map<CountsKey, long[]> map) {
        updates.forEach((key, value) -> map.compute((CountsKey)key, (k, v) -> {
            if (v == null) {
                return Arrays.copyOf(value, ((long[])value).length);
            }
            return this.updateEachValue((long[])v, (long[])value);
        }));
    }

    private long[] updateEachValue(long[] v, long[] value) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = v[i] + value[i];
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CountsSnapshot snapshot(long txId) {
        this.lock.writeLock().lock();
        try {
            if (this.snapshot != null) {
                throw new IllegalStateException("Cannot perform snapshot while another snapshot is processing.");
            }
            long snapshotTxId = Math.max(txId, this.lastTxId.highestEverSeen());
            this.snapshot = new CountsSnapshot(snapshotTxId, InMemoryCountsStore.copyOfMap(this.map));
        }
        finally {
            this.lock.writeLock().unlock();
        }
        try {
            Predicates.awaitForever(() -> this.lastTxId.getHighestGapFreeNumber() >= this.snapshot.getTxId(), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            CountsSnapshot snapshotTxId = this.snapshot;
            return snapshotTxId;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw Exceptions.withCause(new UnderlyingStorageException("Construction of snapshot was interrupted."), ex);
        }
        finally {
            this.snapshot = null;
        }
    }

    private static Map<CountsKey, long[]> copyOfMap(Map<CountsKey, long[]> mapToCopy) {
        ConcurrentHashMap<CountsKey, long[]> newMap = new ConcurrentHashMap<CountsKey, long[]>();
        mapToCopy.forEach((key, value) -> newMap.put((CountsKey)key, Arrays.copyOf(value, ((long[])value).length)));
        return newMap;
    }
}

