/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.function.Predicate;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreIdIterator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class Scanner {
    @SafeVarargs
    public static <R extends AbstractBaseRecord> ResourceIterable<R> scan(RecordStore<R> store, Predicate<? super R> ... filters) {
        return Scanner.scan(store, true, filters);
    }

    @SafeVarargs
    public static <R extends AbstractBaseRecord> ResourceIterable<R> scan(RecordStore<R> store, boolean forward, Predicate<? super R> ... filters) {
        return () -> new Scan(store, forward, filters);
    }

    private static class Scan<R extends AbstractBaseRecord>
    extends PrefetchingResourceIterator<R> {
        private final PrimitiveLongIterator ids;
        private final RecordCursor<R> cursor;
        private final Predicate<? super R>[] filters;

        public Scan(RecordStore<R> store, boolean forward, Predicate<? super R> ... filters) {
            this.filters = filters;
            this.ids = new StoreIdIterator(store, forward);
            this.cursor = store.newRecordCursor(store.newRecord());
            this.cursor.acquire(0L, RecordLoad.CHECK);
        }

        protected R fetchNextOrNull() {
            while (this.ids.hasNext()) {
                AbstractBaseRecord record;
                if (!this.cursor.next(this.ids.next()) || !this.passesFilters(record = (AbstractBaseRecord)this.cursor.get())) continue;
                return (R)record;
            }
            return null;
        }

        private boolean passesFilters(R record) {
            for (Predicate<R> predicate : this.filters) {
                if (predicate.test(record)) continue;
                return false;
            }
            return true;
        }

        public void close() {
            this.cursor.close();
        }
    }
}

