/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.ExecutingQuery;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContext;
import org.neo4j.kernel.impl.query.QuerySource;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;

public class Neo4jTransactionalContextFactory
implements TransactionalContextFactory {
    private final Supplier<Statement> statementSupplier;
    private final Supplier<GraphDatabaseQueryService> queryServiceSupplier;
    private final ThreadToStatementContextBridge txBridge;
    private final PropertyContainerLocker locker;
    private final DbmsOperations dbmsOperations;
    private final Guard guard;

    public Neo4jTransactionalContextFactory(GraphDatabaseFacade.SPI spi, PropertyContainerLocker locker) {
        this(locker, spi::currentStatement, spi.resolver());
    }

    @Deprecated
    public Neo4jTransactionalContextFactory(GraphDatabaseQueryService queryService, PropertyContainerLocker locker) {
        this(queryService, locker, (Supplier)queryService.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class));
    }

    public Neo4jTransactionalContextFactory(GraphDatabaseQueryService queryService, PropertyContainerLocker locker, Supplier<Statement> statementSupplier) {
        this(Suppliers.singleton((Object)queryService), statementSupplier, (ThreadToStatementContextBridge)queryService.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class), locker, (DbmsOperations)queryService.getDependencyResolver().resolveDependency(DbmsOperations.class), (Guard)queryService.getDependencyResolver().resolveDependency(Guard.class));
    }

    public Neo4jTransactionalContextFactory(PropertyContainerLocker locker, Supplier<Statement> statementSupplier, DependencyResolver resolver) {
        this(() -> (GraphDatabaseQueryService)resolver.resolveDependency(GraphDatabaseQueryService.class), statementSupplier, (ThreadToStatementContextBridge)resolver.resolveDependency(ThreadToStatementContextBridge.class), locker, (DbmsOperations)resolver.resolveDependency(DbmsOperations.class), (Guard)resolver.resolveDependency(Guard.class));
    }

    public Neo4jTransactionalContextFactory(Supplier<GraphDatabaseQueryService> queryServiceSupplier, Supplier<Statement> statementSupplier, ThreadToStatementContextBridge txBridge, PropertyContainerLocker locker, DbmsOperations dbmsOperations, Guard guard) {
        this.queryServiceSupplier = queryServiceSupplier;
        this.statementSupplier = statementSupplier;
        this.txBridge = txBridge;
        this.locker = locker;
        this.dbmsOperations = dbmsOperations;
        this.guard = guard;
    }

    @Override
    public Neo4jTransactionalContext newContext(QuerySource querySource, InternalTransaction tx, String queryText, Map<String, Object> queryParameters) {
        Statement statement = this.statementSupplier.get();
        GraphDatabaseQueryService queryService = this.queryServiceSupplier.get();
        QuerySource querySourceWithUserName = querySource.append(tx.mode().name());
        ExecutingQuery executingQuery = statement.queryRegistration().startQueryExecution(querySourceWithUserName, queryText, queryParameters);
        return new Neo4jTransactionalContext(queryService, tx, tx.transactionType(), tx.mode(), this.statementSupplier, executingQuery, this.locker, this.txBridge, this.dbmsOperations, this.guard);
    }
}

