/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.function.Supplier;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.ExecutingQuery;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryRegistryOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.query.TransactionalContext;

public class Neo4jTransactionalContext
implements TransactionalContext {
    private final GraphDatabaseQueryService graph;
    private final ThreadToStatementContextBridge txBridge;
    private final KernelTransaction.Type transactionType;
    private final AccessMode mode;
    private final Supplier<Statement> statementSupplier;
    private final DbmsOperations dbmsOperations;
    private final Guard guard;
    private final ExecutingQuery executingQuery;
    private final PropertyContainerLocker locker;
    private InternalTransaction transaction;
    private Statement statement;
    private boolean isOpen = true;

    public Neo4jTransactionalContext(GraphDatabaseQueryService graph, InternalTransaction initialTransaction, KernelTransaction.Type transactionType, AccessMode transactionMode, Supplier<Statement> statementSupplier, ExecutingQuery executingQuery, PropertyContainerLocker locker, ThreadToStatementContextBridge txBridge, DbmsOperations dbmsOperations, Guard guard) {
        this.graph = graph;
        this.transaction = initialTransaction;
        this.transactionType = transactionType;
        this.mode = transactionMode;
        this.statementSupplier = statementSupplier;
        this.statement = statementSupplier.get();
        this.executingQuery = executingQuery;
        this.locker = locker;
        this.txBridge = txBridge;
        this.dbmsOperations = dbmsOperations;
        this.guard = guard;
    }

    @Override
    public ExecutingQuery executingQuery() {
        return this.executingQuery;
    }

    @Override
    public ReadOperations readOperations() {
        return this.statement.readOperations();
    }

    @Override
    public DbmsOperations dbmsOperations() {
        return this.dbmsOperations;
    }

    @Override
    public boolean isTopLevelTx() {
        return this.transaction.transactionType() == KernelTransaction.Type.implicit;
    }

    @Override
    public void close(boolean success) {
        if (this.isOpen) {
            try {
                this.statement.queryRegistration().unregisterExecutingQuery(this.executingQuery);
                this.statement.close();
                if (success) {
                    this.transaction.success();
                } else {
                    this.transaction.failure();
                }
                this.transaction.close();
            }
            finally {
                this.statement = null;
                this.transaction = null;
                this.isOpen = false;
            }
        }
    }

    @Override
    public void terminate() {
        if (this.isOpen) {
            try {
                this.transaction.terminate();
                this.close(false);
            }
            catch (NotInTransactionException notInTransactionException) {
                // empty catch block
            }
        }
    }

    @Override
    public void commitAndRestartTx() {
        QueryRegistryOperations oldQueryRegistryOperations = this.statement.queryRegistration();
        InternalTransaction oldTransaction = this.transaction;
        KernelTransaction oldKernelTx = this.txBridge.getKernelTransactionBoundToThisThread(true);
        this.txBridge.unbindTransactionFromCurrentThread();
        this.transaction = this.graph.beginTransaction(this.transactionType, this.mode);
        this.statement = this.txBridge.get();
        this.statement.queryRegistration().registerExecutingQuery(this.executingQuery);
        KernelTransaction kernelTx = this.txBridge.getKernelTransactionBoundToThisThread(true);
        this.txBridge.unbindTransactionFromCurrentThread();
        this.txBridge.bindTransactionToCurrentThread(oldKernelTx);
        oldQueryRegistryOperations.unregisterExecutingQuery(this.executingQuery);
        try {
            oldTransaction.success();
            oldTransaction.close();
        }
        catch (Throwable t) {
            this.txBridge.bindTransactionToCurrentThread(kernelTx);
            this.transaction.failure();
            this.transaction.close();
            this.txBridge.unbindTransactionFromCurrentThread();
            throw t;
        }
        this.txBridge.unbindTransactionFromCurrentThread();
        this.txBridge.bindTransactionToCurrentThread(kernelTx);
    }

    @Override
    public void cleanForReuse() {
        this.statement.queryRegistration().unregisterExecutingQuery(this.executingQuery);
        this.statement.close();
        this.statement = this.txBridge.get();
        this.statement.queryRegistration().registerExecutingQuery(this.executingQuery);
    }

    @Override
    public TransactionalContext getOrBeginNewIfClosed() {
        if (!this.isOpen) {
            this.transaction = this.graph.beginTransaction(this.transactionType, this.mode);
            this.statement = this.statementSupplier.get();
            this.statement.queryRegistration().registerExecutingQuery(this.executingQuery);
            this.isOpen = true;
        }
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public GraphDatabaseQueryService graph() {
        return this.graph;
    }

    @Override
    public Statement statement() {
        return this.statement;
    }

    @Override
    public void check() {
        this.guard.check((KernelStatement)this.statement);
    }

    @Override
    public TxStateHolder stateView() {
        return (KernelStatement)this.statement;
    }

    @Override
    public Lock acquireWriteLock(PropertyContainer p) {
        return this.locker.exclusiveLock(this.statement, p);
    }

    @Override
    public KernelTransaction.Revertable restrictCurrentTransaction(AccessMode accessMode) {
        return this.transaction.overrideWith(accessMode);
    }

    @Override
    public AccessMode accessMode() {
        return this.mode;
    }
}

