/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.collection.RawIterator;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.FieldSignature;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.proc.QualifiedName;
import org.neo4j.kernel.api.proc.UserFunctionSignature;

public class ProcedureRegistry {
    private final Map<QualifiedName, CallableProcedure> procedures = new HashMap<QualifiedName, CallableProcedure>();
    private final Map<QualifiedName, CallableUserFunction> functions = new HashMap<QualifiedName, CallableUserFunction>();

    public void register(CallableProcedure proc, boolean overrideCurrentImplementation) throws ProcedureException {
        ProcedureSignature signature = proc.signature();
        QualifiedName name = signature.name();
        String descriptiveName = signature.toString();
        this.validateSignature(descriptiveName, signature.inputSignature(), "input");
        this.validateSignature(descriptiveName, signature.outputSignature(), "output");
        if (!signature.isVoid() && signature.outputSignature().isEmpty()) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Procedures with zero output fields must be declared as VOID", new Object[0]);
        }
        CallableProcedure oldImplementation = this.procedures.get(name);
        if (oldImplementation == null) {
            this.procedures.put(name, proc);
        } else if (overrideCurrentImplementation) {
            this.procedures.put(name, proc);
        } else {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register procedure, because the name `%s` is already in use.", name);
        }
    }

    public void register(CallableUserFunction function, boolean overrideCurrentImplementation) throws ProcedureException {
        UserFunctionSignature signature = function.signature();
        QualifiedName name = signature.name();
        CallableUserFunction oldImplementation = this.functions.get(name);
        if (oldImplementation == null) {
            this.functions.put(name, function);
        } else if (overrideCurrentImplementation) {
            this.functions.put(name, function);
        } else {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register function, because the name `%s` is already in use.", name);
        }
    }

    private void validateSignature(String descriptiveName, List<FieldSignature> fields, String fieldType) throws ProcedureException {
        HashSet<String> names = new HashSet<String>();
        for (FieldSignature field : fields) {
            if (names.add(field.name())) continue;
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Procedure `%s` cannot be registered, because it contains a duplicated " + fieldType + " field, '%s'. " + "You need to rename or remove one of the duplicate fields.", descriptiveName, field.name());
        }
    }

    public ProcedureSignature procedure(QualifiedName name) throws ProcedureException {
        CallableProcedure proc = this.procedures.get(name);
        if (proc == null) {
            throw this.noSuchProcedure(name);
        }
        return proc.signature();
    }

    public Optional<UserFunctionSignature> function(QualifiedName name) {
        CallableUserFunction func = this.functions.get(name);
        if (func == null) {
            return Optional.empty();
        }
        return Optional.of(func.signature());
    }

    public RawIterator<Object[], ProcedureException> callProcedure(Context ctx, QualifiedName name, Object[] input) throws ProcedureException {
        CallableProcedure proc = this.procedures.get(name);
        if (proc == null) {
            throw this.noSuchProcedure(name);
        }
        return proc.apply(ctx, input);
    }

    public Object callFunction(Context ctx, QualifiedName name, Object[] input) throws ProcedureException {
        CallableUserFunction func = this.functions.get(name);
        if (func == null) {
            throw this.noSuchFunction(name);
        }
        return func.apply(ctx, input);
    }

    private ProcedureException noSuchProcedure(QualifiedName name) {
        return new ProcedureException((Status)Status.Procedure.ProcedureNotFound, "There is no procedure with the name `%s` registered for this database instance. Please ensure you've spelled the procedure name correctly and that the procedure is properly deployed.", name);
    }

    private ProcedureException noSuchFunction(QualifiedName name) {
        return new ProcedureException((Status)Status.Procedure.ProcedureNotFound, "There is no function with the name `%s` registered for this database instance. Please ensure you've spelled the function name correctly and that the function is properly deployed.", name);
    }

    public Set<ProcedureSignature> getAllProcedures() {
        return this.procedures.values().stream().map(CallableProcedure::signature).collect(Collectors.toSet());
    }

    public Set<UserFunctionSignature> getAllFunctions() {
        return this.functions.values().stream().map(CallableUserFunction::signature).collect(Collectors.toSet());
    }
}

