/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.ToIntFunction;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.kernel.impl.transaction.state.TokenCreator;
import org.neo4j.storageengine.api.Token;
import org.neo4j.unsafe.impl.batchimport.store.BatchingRecordAccess;

public abstract class BatchingTokenRepository<RECORD extends TokenRecord, TOKEN extends Token>
implements ToIntFunction<Object> {
    private final Map<String, Integer> tokens = new HashMap<String, Integer>();
    private final TokenStore<RECORD, TOKEN> store;
    private int highId;

    public BatchingTokenRepository(TokenStore<RECORD, TOKEN> store) {
        this.store = store;
        this.highId = (int)store.getHighId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrCreateId(String name) {
        assert (name != null);
        Integer id = this.tokens.get(name);
        if (id == null) {
            Map<String, Integer> map = this.tokens;
            synchronized (map) {
                id = this.tokens.get(name);
                if (id == null) {
                    id = this.highId++;
                    this.tokens.put(name, id);
                }
            }
        }
        return id;
    }

    public int getOrCreateId(Object key) {
        if (key instanceof String) {
            return this.getOrCreateId((String)key);
        }
        if (key instanceof Integer) {
            return (Integer)key;
        }
        throw new IllegalArgumentException("Expected either a String or Integer for property key, but was '" + key + "'" + ", " + key.getClass());
    }

    @Override
    public int applyAsInt(Object key) {
        return this.getOrCreateId(key);
    }

    public long[] getOrCreateIds(String[] names) {
        int from;
        long[] result = new long[names.length];
        int to = 0;
        for (from = 0; from < names.length; ++from) {
            int id = this.getOrCreateId(names[from]);
            if (this.contains(result, id, to)) continue;
            result[to++] = id;
        }
        if (to < from) {
            result = Arrays.copyOf(result, to);
        }
        Arrays.sort(result);
        return result;
    }

    private boolean contains(long[] array, long id, int arrayLength) {
        for (int i = 0; i < arrayLength; ++i) {
            if (array[i] != id) continue;
            return true;
        }
        return false;
    }

    public int getHighId() {
        return this.highId;
    }

    protected abstract RECORD createRecord(int var1);

    public void close() {
        BatchingRecordAccess recordAccess = new BatchingRecordAccess<Integer, RECORD, Void>(){

            @Override
            protected RECORD createRecord(Integer key, Void additionalData) {
                return BatchingTokenRepository.this.createRecord(key);
            }
        };
        TokenCreator<RECORD, TOKEN> creator = new TokenCreator<RECORD, TOKEN>(this.store);
        int highest = 1;
        for (Map.Entry<Integer, String> tokenToCreate : this.sortCreatedTokensById()) {
            creator.createToken(tokenToCreate.getValue(), tokenToCreate.getKey(), recordAccess);
            highest = Math.max(highest, tokenToCreate.getKey());
        }
        int highestId = (int)this.store.getHighestPossibleIdInUse();
        for (TokenRecord record : recordAccess.records()) {
            this.store.updateRecord(record);
            highestId = Math.max(highestId, record.getIntId());
        }
        this.store.setHighestPossibleIdInUse(highestId);
    }

    private Iterable<Map.Entry<Integer, String>> sortCreatedTokensById() {
        TreeMap<Integer, String> sorted = new TreeMap<Integer, String>();
        for (Map.Entry<String, Integer> entry : this.tokens.entrySet()) {
            sorted.put(entry.getValue(), entry.getKey());
        }
        return sorted.entrySet();
    }

    public static class BatchingRelationshipTypeTokenRepository
    extends BatchingTokenRepository<RelationshipTypeTokenRecord, RelationshipTypeToken> {
        public BatchingRelationshipTypeTokenRepository(TokenStore<RelationshipTypeTokenRecord, RelationshipTypeToken> store) {
            super(store);
        }

        @Override
        protected RelationshipTypeTokenRecord createRecord(int key) {
            return new RelationshipTypeTokenRecord(key);
        }
    }

    public static class BatchingLabelTokenRepository
    extends BatchingTokenRepository<LabelTokenRecord, Token> {
        public BatchingLabelTokenRepository(TokenStore<LabelTokenRecord, Token> store) {
            super(store);
        }

        @Override
        protected LabelTokenRecord createRecord(int key) {
            return new LabelTokenRecord(key);
        }
    }

    public static class BatchingPropertyKeyTokenRepository
    extends BatchingTokenRepository<PropertyKeyTokenRecord, Token> {
        public BatchingPropertyKeyTokenRepository(TokenStore<PropertyKeyTokenRecord, Token> store) {
            super(store);
        }

        @Override
        protected PropertyKeyTokenRecord createRecord(int key) {
            return new PropertyKeyTokenRecord(key);
        }

        public void propertyKeysAndValues(PropertyBlock[] target, int offset, Object[] properties, PropertyCreator creator) {
            int count = properties.length >> 1;
            int cursor = 0;
            for (int i = 0; i < count; ++i) {
                int key = this.getOrCreateId(properties[cursor++]);
                Object value = properties[cursor++];
                target[offset + i] = creator.encodeValue(new PropertyBlock(), key, value);
            }
        }
    }
}

