/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.util.function.Supplier;
import org.neo4j.kernel.impl.api.KernelTransactionsSnapshot;
import org.neo4j.kernel.impl.store.id.DelayedBuffer;
import org.neo4j.kernel.impl.store.id.IdGenerator;

class BufferingIdGenerator
extends IdGenerator.Delegate {
    private DelayedBuffer<KernelTransactionsSnapshot> buffer;

    public BufferingIdGenerator(IdGenerator delegate) {
        super(delegate);
    }

    void initialize(Supplier<KernelTransactionsSnapshot> boundaries) {
        this.buffer = new DelayedBuffer<KernelTransactionsSnapshot>(boundaries, KernelTransactionsSnapshot::allClosed, 10000, freedIds -> {
            for (long id : freedIds) {
                this.actualFreeId(id);
            }
        });
    }

    private void actualFreeId(long id) {
        super.freeId(id);
    }

    @Override
    public void freeId(long id) {
        this.buffer.offer(id);
    }

    void maintenance() {
        this.buffer.maintenance();
    }
}

