/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.util.JobScheduler;

public class IndexSamplingJobTracker {
    private final JobScheduler jobScheduler;
    private final int jobLimit;
    private final Set<IndexDescriptor> executingJobDescriptors;
    private final Lock lock = new ReentrantLock(true);
    private final Condition canSchedule = this.lock.newCondition();
    private final Condition allJobsFinished = this.lock.newCondition();
    private boolean stopped;

    public IndexSamplingJobTracker(IndexSamplingConfig config, JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
        this.jobLimit = config.jobLimit();
        this.executingJobDescriptors = new HashSet<IndexDescriptor>();
    }

    public boolean canExecuteMoreSamplingJobs() {
        this.lock.lock();
        try {
            boolean bl = !this.stopped && this.executingJobDescriptors.size() < this.jobLimit;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void scheduleSamplingJob(final IndexSamplingJob samplingJob) {
        this.lock.lock();
        try {
            if (this.stopped) {
                return;
            }
            IndexDescriptor descriptor = samplingJob.descriptor();
            if (this.executingJobDescriptors.contains(descriptor)) {
                return;
            }
            this.executingJobDescriptors.add(descriptor);
            this.jobScheduler.schedule(JobScheduler.Groups.indexSampling, new Runnable(){

                @Override
                public void run() {
                    try {
                        samplingJob.run();
                    }
                    finally {
                        IndexSamplingJobTracker.this.samplingJobCompleted(samplingJob);
                    }
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    private void samplingJobCompleted(IndexSamplingJob samplingJob) {
        this.lock.lock();
        try {
            this.executingJobDescriptors.remove(samplingJob.descriptor());
            this.canSchedule.signalAll();
            this.allJobsFinished.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void waitUntilCanExecuteMoreSamplingJobs() {
        this.lock.lock();
        try {
            while (!this.canExecuteMoreSamplingJobs()) {
                if (this.stopped) {
                    return;
                }
                this.canSchedule.awaitUninterruptibly();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitAllJobs(long time, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            if (this.stopped) {
                return;
            }
            while (!this.executingJobDescriptors.isEmpty()) {
                this.allJobsFinished.await(time, unit);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stopAndAwaitAllJobs() {
        this.lock.lock();
        try {
            this.stopped = true;
            while (!this.executingJobDescriptors.isEmpty()) {
                this.allJobsFinished.awaitUninterruptibly();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

